/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.wifi.WifiNetworkSpecifier;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareUtils;
import android.net.wifi.usd.Config;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.net.wifi.flags.usd")
public class PublishConfig
extends Config
implements Parcelable {
    private final int mSolicitedTransmissionType;
    private final int mAnnouncementPeriodMillis;
    private final boolean mEnableEvents;
    @NonNull
    public static final Parcelable.Creator<PublishConfig> CREATOR = new Parcelable.Creator<PublishConfig>(){

        @Override
        public PublishConfig createFromParcel(Parcel in) {
            return new PublishConfig(in);
        }

        public PublishConfig[] newArray(int size) {
            return new PublishConfig[size];
        }
    };

    private PublishConfig(Parcel in) {
        super(in.createByteArray(), in.readInt(), in.readInt(), in.createByteArray(), in.createByteArray(), in.createByteArray(), in.createIntArray());
        this.mSolicitedTransmissionType = in.readInt();
        this.mAnnouncementPeriodMillis = in.readInt();
        this.mEnableEvents = in.readBoolean();
    }

    private PublishConfig(Builder builder) {
        super(builder.mServiceName, builder.mTtlSeconds, builder.mServiceProtoType, builder.mTxMatchFilterTlv, builder.mRxMatchFilterTlv, builder.mServiceSpecificInfo, builder.mOperatingFrequencies);
        this.mSolicitedTransmissionType = builder.mSolicitedTransmissionType;
        this.mAnnouncementPeriodMillis = builder.mAnnouncementPeriodMillis;
        this.mEnableEvents = builder.mEnableEvents;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByteArray(this.getServiceName());
        dest.writeInt(this.getTtlSeconds());
        dest.writeInt(this.getServiceProtoType());
        dest.writeByteArray(this.getTxMatchFilterTlv());
        dest.writeByteArray(this.getRxMatchFilterTlv());
        dest.writeByteArray(this.getServiceSpecificInfo());
        dest.writeIntArray(this.getOperatingFrequenciesMhz());
        dest.writeInt(this.mSolicitedTransmissionType);
        dest.writeInt(this.mAnnouncementPeriodMillis);
        dest.writeBoolean(this.mEnableEvents);
    }

    public int getSolicitedTransmissionType() {
        return this.mSolicitedTransmissionType;
    }

    public int getAnnouncementPeriodMillis() {
        return this.mAnnouncementPeriodMillis;
    }

    public boolean isEventsEnabled() {
        return this.mEnableEvents;
    }

    @Override
    public String toString() {
        return super.toString() + " PublishConfig{mSolicitedTransmissionType=" + this.mSolicitedTransmissionType + ", mAnnouncementPeriodMillis=" + this.mAnnouncementPeriodMillis + ", mEnableEvents=" + this.mEnableEvents + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishConfig)) {
            return false;
        }
        PublishConfig that = (PublishConfig)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.mSolicitedTransmissionType == that.mSolicitedTransmissionType && this.mAnnouncementPeriodMillis == that.mAnnouncementPeriodMillis && this.mEnableEvents == that.mEnableEvents;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mSolicitedTransmissionType, this.mAnnouncementPeriodMillis, this.mEnableEvents);
    }

    public static class Builder {
        private int mSolicitedTransmissionType = 0;
        private int mAnnouncementPeriodMillis = 100;
        private boolean mEnableEvents = false;
        private final byte[] mServiceName;
        private int mTtlSeconds = 3000;
        private int mServiceProtoType = 0;
        private byte[] mTxMatchFilterTlv = null;
        private byte[] mRxMatchFilterTlv = null;
        private byte[] mServiceSpecificInfo = null;
        private int[] mOperatingFrequencies = null;

        public Builder(@NonNull String serviceName) {
            Objects.requireNonNull(serviceName, "serviceName must not be null");
            this.mServiceName = serviceName.getBytes(StandardCharsets.UTF_8);
            WifiAwareUtils.validateServiceName(this.mServiceName);
        }

        @NonNull
        public Builder setTtlSeconds(int ttlSeconds) {
            if (ttlSeconds < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSeconds = ttlSeconds;
            return this;
        }

        @NonNull
        public Builder setServiceProtoType(int serviceProtoType) {
            if (serviceProtoType < 0 || serviceProtoType > 1) {
                throw new IllegalArgumentException("Invalid serviceProtoType - " + serviceProtoType);
            }
            this.mServiceProtoType = serviceProtoType;
            return this;
        }

        @NonNull
        public Builder setTxMatchFilter(@NonNull List<byte[]> txMatchFilter) {
            Objects.requireNonNull(txMatchFilter, "txMatchFilter must not be null");
            this.mTxMatchFilterTlv = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(txMatchFilter).getArray();
            if (!TlvBufferUtils.isValid(this.mTxMatchFilterTlv, 0, 1)) {
                throw new IllegalArgumentException("Invalid txMatchFilter configuration - LV fields do not match up to length");
            }
            return this;
        }

        @NonNull
        public Builder setRxMatchFilter(@NonNull List<byte[]> rxMatchFilter) {
            Objects.requireNonNull(rxMatchFilter, "rxMatchFilter must not be null");
            this.mRxMatchFilterTlv = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(rxMatchFilter).getArray();
            if (!TlvBufferUtils.isValid(this.mRxMatchFilterTlv, 0, 1)) {
                throw new IllegalArgumentException("Invalid rxMatchFilter configuration - LV fields do not match up to length");
            }
            return this;
        }

        @NonNull
        public Builder setSolicitedTransmissionType(int solicitedTransmissionType) {
            if (solicitedTransmissionType < 0 || solicitedTransmissionType > 1) {
                throw new IllegalArgumentException("Invalid solicitedTransmissionType - " + solicitedTransmissionType);
            }
            this.mSolicitedTransmissionType = solicitedTransmissionType;
            return this;
        }

        @NonNull
        public Builder setAnnouncementPeriodMillis(int announcementPeriodMillis) {
            if (announcementPeriodMillis < 0) {
                throw new IllegalArgumentException("Invalid announcementPeriodMillis - must be non-negative");
            }
            this.mAnnouncementPeriodMillis = announcementPeriodMillis;
            return this;
        }

        @NonNull
        public Builder setEventsEnabled(boolean enableEvents) {
            this.mEnableEvents = enableEvents;
            return this;
        }

        @NonNull
        public Builder setServiceSpecificInfo(@NonNull byte[] serviceSpecificInfo) {
            Objects.requireNonNull(serviceSpecificInfo, "serviceSpecificInfo must not be null");
            this.mServiceSpecificInfo = (byte[])serviceSpecificInfo.clone();
            return this;
        }

        @NonNull
        public Builder setOperatingFrequenciesMhz(@NonNull int[] operatingFrequencies) {
            Objects.requireNonNull(operatingFrequencies, "operatingFrequencies must not be null");
            if (operatingFrequencies.length > 32 || !WifiNetworkSpecifier.validateChannelFrequencyInMhz(operatingFrequencies)) {
                throw new IllegalArgumentException("Invalid operatingFrequencies");
            }
            this.mOperatingFrequencies = (int[])operatingFrequencies.clone();
            return this;
        }

        @NonNull
        public PublishConfig build() {
            return new PublishConfig(this);
        }
    }
}

