/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.usd;

import android.net.wifi.IBooleanListener;
import android.net.wifi.usd.Characteristics;
import android.net.wifi.usd.IPublishSessionCallback;
import android.net.wifi.usd.ISubscribeSessionCallback;
import android.net.wifi.usd.PublishConfig;
import android.net.wifi.usd.SubscribeConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUsdManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.usd.IUsdManager";

    public Characteristics getCharacteristics() throws RemoteException;

    public void sendMessage(int var1, int var2, byte[] var3, IBooleanListener var4) throws RemoteException;

    public void cancelSubscribe(int var1) throws RemoteException;

    public void cancelPublish(int var1) throws RemoteException;

    public void updatePublish(int var1, byte[] var2) throws RemoteException;

    public void publish(PublishConfig var1, IPublishSessionCallback var2) throws RemoteException;

    public void subscribe(SubscribeConfig var1, ISubscribeSessionCallback var2) throws RemoteException;

    public void registerSubscriberStatusListener(IBooleanListener var1) throws RemoteException;

    public void unregisterSubscriberStatusListener(IBooleanListener var1) throws RemoteException;

    public void registerPublisherStatusListener(IBooleanListener var1) throws RemoteException;

    public void unregisterPublisherStatusListener(IBooleanListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUsdManager {
        static final int TRANSACTION_getCharacteristics = 1;
        static final int TRANSACTION_sendMessage = 2;
        static final int TRANSACTION_cancelSubscribe = 3;
        static final int TRANSACTION_cancelPublish = 4;
        static final int TRANSACTION_updatePublish = 5;
        static final int TRANSACTION_publish = 6;
        static final int TRANSACTION_subscribe = 7;
        static final int TRANSACTION_registerSubscriberStatusListener = 8;
        static final int TRANSACTION_unregisterSubscriberStatusListener = 9;
        static final int TRANSACTION_registerPublisherStatusListener = 10;
        static final int TRANSACTION_unregisterPublisherStatusListener = 11;

        public Stub() {
            this.attachInterface(this, IUsdManager.DESCRIPTOR);
        }

        public static IUsdManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUsdManager.DESCRIPTOR);
            if (iin != null && iin instanceof IUsdManager) {
                return (IUsdManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getCharacteristics";
                }
                case 2: {
                    return "sendMessage";
                }
                case 3: {
                    return "cancelSubscribe";
                }
                case 4: {
                    return "cancelPublish";
                }
                case 5: {
                    return "updatePublish";
                }
                case 6: {
                    return "publish";
                }
                case 7: {
                    return "subscribe";
                }
                case 8: {
                    return "registerSubscriberStatusListener";
                }
                case 9: {
                    return "unregisterSubscriberStatusListener";
                }
                case 10: {
                    return "registerPublisherStatusListener";
                }
                case 11: {
                    return "unregisterPublisherStatusListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUsdManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Characteristics _result = this.getCharacteristics();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    IBooleanListener _arg3 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.sendMessage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    this.cancelSubscribe(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.cancelPublish(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    this.updatePublish(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    PublishConfig _arg0 = data.readTypedObject(PublishConfig.CREATOR);
                    IPublishSessionCallback _arg1 = IPublishSessionCallback.Stub.asInterface(data.readStrongBinder());
                    this.publish(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    SubscribeConfig _arg0 = data.readTypedObject(SubscribeConfig.CREATOR);
                    ISubscribeSessionCallback _arg1 = ISubscribeSessionCallback.Stub.asInterface(data.readStrongBinder());
                    this.subscribe(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.registerSubscriberStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSubscriberStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.registerPublisherStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBooleanListener _arg0 = IBooleanListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterPublisherStatusListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IUsdManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUsdManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Characteristics getCharacteristics() throws RemoteException {
                Characteristics _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Characteristics.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int sessionId, int peerId, byte[] message, IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(peerId);
                    _data.writeByteArray(message);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSubscribe(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelPublish(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePublish(int sessionId, byte[] ssi) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeByteArray(ssi);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(PublishConfig publishConfig, IPublishSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeTypedObject(publishConfig, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribe(SubscribeConfig subscribeConfig, ISubscribeSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeTypedObject(subscribeConfig, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSubscriberStatusListener(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSubscriberStatusListener(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPublisherStatusListener(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPublisherStatusListener(IBooleanListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUsdManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUsdManager {
        @Override
        public Characteristics getCharacteristics() throws RemoteException {
            return null;
        }

        @Override
        public void sendMessage(int sessionId, int peerId, byte[] message, IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void cancelSubscribe(int sessionId) throws RemoteException {
        }

        @Override
        public void cancelPublish(int sessionId) throws RemoteException {
        }

        @Override
        public void updatePublish(int sessionId, byte[] ssi) throws RemoteException {
        }

        @Override
        public void publish(PublishConfig publishConfig, IPublishSessionCallback callback) throws RemoteException {
        }

        @Override
        public void subscribe(SubscribeConfig subscribeConfig, ISubscribeSessionCallback callback) throws RemoteException {
        }

        @Override
        public void registerSubscriberStatusListener(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void unregisterSubscriberStatusListener(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void registerPublisherStatusListener(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public void unregisterPublisherStatusListener(IBooleanListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

