/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@RequiresApi(value=36)
@FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
public class WifiP2pUsdBasedServiceConfig
implements Parcelable {
    private static final int SERVICE_SPECIFIC_INFO_MAXIMUM_LENGTH = 1024;
    public static final int SERVICE_PROTOCOL_TYPE_BONJOUR = 1;
    public static final int SERVICE_PROTOCOL_TYPE_GENERIC = 2;
    private int mServiceProtocolType;
    private String mServiceName;
    private byte[] mServiceSpecificInfo;
    @NonNull
    public static final Parcelable.Creator<WifiP2pUsdBasedServiceConfig> CREATOR = new Parcelable.Creator<WifiP2pUsdBasedServiceConfig>(){

        @Override
        public WifiP2pUsdBasedServiceConfig createFromParcel(Parcel in) {
            WifiP2pUsdBasedServiceConfig config = new WifiP2pUsdBasedServiceConfig();
            config.mServiceProtocolType = in.readInt();
            config.mServiceName = in.readString();
            config.mServiceSpecificInfo = in.createByteArray();
            return config;
        }

        public WifiP2pUsdBasedServiceConfig[] newArray(int size) {
            return new WifiP2pUsdBasedServiceConfig[size];
        }
    };

    public int getServiceProtocolType() {
        return this.mServiceProtocolType;
    }

    @NonNull
    public String getServiceName() {
        return this.mServiceName;
    }

    @Nullable
    public byte[] getServiceSpecificInfo() {
        return this.mServiceSpecificInfo;
    }

    public static int getMaxAllowedServiceSpecificInfoLength() {
        return 1024;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("WifiP2pUsdBasedServiceConfig:");
        sbuf.append("\n Protocol type: ").append(this.mServiceProtocolType);
        sbuf.append("\n Service name : ").append(this.mServiceName);
        sbuf.append("\n Service specific info : ").append(this.mServiceSpecificInfo == null ? "<null>" : Arrays.toString(this.mServiceSpecificInfo));
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mServiceProtocolType);
        dest.writeString(this.mServiceName);
        dest.writeByteArray(this.mServiceSpecificInfo);
    }

    public static class Builder {
        private static final int SERVICE_NAME_MAXIMUM_LENGTH = 100;
        private int mServiceProtocolType = 2;
        @NonNull
        private String mServiceName;
        byte[] mServiceSpecificInfo;

        public Builder(@NonNull String serviceName) {
            Objects.requireNonNull(serviceName, "Service name cannot be null");
            if (TextUtils.isEmpty(serviceName)) {
                throw new IllegalArgumentException("Service name cannot be empty!");
            }
            if (serviceName.length() > 100) {
                throw new IllegalArgumentException("Service name length: " + serviceName.length() + " must be less than " + 100);
            }
            this.mServiceName = serviceName;
        }

        @NonNull
        public Builder setServiceProtocolType(int serviceProtocolType) {
            if (serviceProtocolType < 0 || serviceProtocolType > 255) {
                throw new IllegalArgumentException("serviceProtocolType must be between 0-255 (inclusive)");
            }
            this.mServiceProtocolType = serviceProtocolType;
            return this;
        }

        @NonNull
        public Builder setServiceSpecificInfo(@Nullable byte[] serviceSpecificInfo) {
            if (serviceSpecificInfo != null && serviceSpecificInfo.length > WifiP2pUsdBasedServiceConfig.getMaxAllowedServiceSpecificInfoLength()) {
                throw new IllegalArgumentException("Service specific info length: " + serviceSpecificInfo.length + " must be less than " + WifiP2pUsdBasedServiceConfig.getMaxAllowedServiceSpecificInfoLength());
            }
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        @NonNull
        public WifiP2pUsdBasedServiceConfig build() {
            if (TextUtils.isEmpty(this.mServiceName)) {
                throw new IllegalStateException("Service name must be non-empty");
            }
            WifiP2pUsdBasedServiceConfig config = new WifiP2pUsdBasedServiceConfig();
            config.mServiceName = this.mServiceName;
            config.mServiceProtocolType = this.mServiceProtocolType;
            config.mServiceSpecificInfo = this.mServiceSpecificInfo;
            return config;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceProtocolType {
    }
}

