/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.wifi.p2p.nsd.WifiP2pUsdBasedServiceConfig;
import android.net.wifi.util.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.wifi.flags.Flags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WifiP2pServiceInfo
implements Parcelable {
    public static final int SERVICE_TYPE_ALL = 0;
    public static final int SERVICE_TYPE_BONJOUR = 1;
    public static final int SERVICE_TYPE_UPNP = 2;
    public static final int SERVICE_TYPE_WS_DISCOVERY = 3;
    public static final int SERVICE_TYPE_VENDOR_SPECIFIC = 255;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private List<String> mQueryList;
    private WifiP2pUsdBasedServiceConfig mUsdServiceConfig;
    private int mUsdSessionId;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public static final Parcelable.Creator<WifiP2pServiceInfo> CREATOR = new Parcelable.Creator<WifiP2pServiceInfo>(){

        @Override
        public WifiP2pServiceInfo createFromParcel(Parcel in) {
            ArrayList<String> data = new ArrayList<String>();
            in.readStringList(data);
            WifiP2pUsdBasedServiceConfig config = null;
            int usdSessionId = 0;
            if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
                config = (WifiP2pUsdBasedServiceConfig)in.readParcelable(WifiP2pUsdBasedServiceConfig.class.getClassLoader());
                usdSessionId = in.readInt();
            }
            return new WifiP2pServiceInfo(data, config, usdSessionId);
        }

        public WifiP2pServiceInfo[] newArray(int size) {
            return new WifiP2pServiceInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    protected WifiP2pServiceInfo(List<String> queryList) {
        if (queryList == null) {
            throw new IllegalArgumentException("query list cannot be null");
        }
        this.mQueryList = queryList;
    }

    private WifiP2pServiceInfo(List<String> queryList, @NonNull WifiP2pUsdBasedServiceConfig usdConfig, int usdSessionId) {
        this.mQueryList = queryList;
        this.mUsdServiceConfig = usdConfig;
        this.mUsdSessionId = usdSessionId;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    public WifiP2pServiceInfo(@NonNull WifiP2pUsdBasedServiceConfig usdConfig) {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        Objects.requireNonNull(usdConfig, "usd based service config cannot be null");
        this.mUsdServiceConfig = usdConfig;
    }

    public List<String> getSupplicantQueryList() {
        return this.mQueryList;
    }

    @RequiresApi(value=36)
    @FlaggedApi(value="com.android.wifi.flags.wifi_direct_r2")
    @Nullable
    public WifiP2pUsdBasedServiceConfig getWifiP2pUsdBasedServiceConfig() {
        if (!Environment.isSdkAtLeastB()) {
            throw new UnsupportedOperationException();
        }
        return this.mUsdServiceConfig;
    }

    public int getUsdSessionId() {
        return this.mUsdSessionId;
    }

    public void setUsdSessionId(int sessionId) {
        this.mUsdSessionId = sessionId;
    }

    static String bin2HexStr(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            String s = null;
            try {
                s = Integer.toHexString(b & 0xFF);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (s.length() == 1) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceInfo)) {
            return false;
        }
        WifiP2pServiceInfo servInfo = (WifiP2pServiceInfo)o;
        return Objects.equals(this.mQueryList, servInfo.mQueryList) && Objects.equals(this.mUsdServiceConfig, servInfo.mUsdServiceConfig);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mQueryList == null ? 0 : this.mQueryList.hashCode());
        result = 31 * result + (this.mUsdServiceConfig == null ? 0 : this.mUsdServiceConfig.hashCode());
        return result;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(this.mQueryList);
        if (Environment.isSdkAtLeastB() && Flags.wifiDirectR2()) {
            dest.writeParcelable(this.mUsdServiceConfig, flags);
            dest.writeInt(this.mUsdSessionId);
        }
    }
}

