/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.annotation.SystemApi;
import android.net.wifi.OuiKeyedData;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.ArrayList;
import java.util.List;

@FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
public class WifiP2pDiscoveryConfig
implements Parcelable {
    private final int mScanType;
    private final int mFrequencyMhz;
    @NonNull
    private final List<OuiKeyedData> mVendorData;
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public static final Parcelable.Creator<WifiP2pDiscoveryConfig> CREATOR = new Parcelable.Creator<WifiP2pDiscoveryConfig>(){

        @Override
        public WifiP2pDiscoveryConfig createFromParcel(Parcel in) {
            return new WifiP2pDiscoveryConfig(in);
        }

        public WifiP2pDiscoveryConfig[] newArray(int size) {
            return new WifiP2pDiscoveryConfig[size];
        }
    };

    private WifiP2pDiscoveryConfig(int scanType, int frequencyMhz, @NonNull List<OuiKeyedData> vendorData) {
        this.mScanType = scanType;
        this.mFrequencyMhz = frequencyMhz;
        this.mVendorData = new ArrayList<OuiKeyedData>(vendorData);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getScanType() {
        return this.mScanType;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int getFrequencyMhz() {
        return this.mFrequencyMhz;
    }

    @SystemApi
    @RequiresApi(value=35)
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    @NonNull
    public List<OuiKeyedData> getVendorData() {
        if (!SdkLevel.isAtLeastV()) {
            throw new UnsupportedOperationException();
        }
        return this.mVendorData;
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n scanType: ").append(this.mScanType);
        sbuf.append("\n frequencyMhz: ").append(this.mFrequencyMhz);
        sbuf.append("\n vendorData: ").append(this.mVendorData);
        return sbuf.toString();
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mScanType);
        dest.writeInt(this.mFrequencyMhz);
        dest.writeList(this.mVendorData);
    }

    @NonNull
    private static List<OuiKeyedData> readOuiKeyedDataList(@NonNull Parcel in) {
        ArrayList<OuiKeyedData> dataList = new ArrayList<OuiKeyedData>();
        if (SdkLevel.isAtLeastT()) {
            in.readList(dataList, OuiKeyedData.class.getClassLoader(), OuiKeyedData.class);
        } else {
            in.readList(dataList, OuiKeyedData.class.getClassLoader());
        }
        return dataList;
    }

    WifiP2pDiscoveryConfig(@NonNull Parcel in) {
        this.mScanType = in.readInt();
        this.mFrequencyMhz = in.readInt();
        this.mVendorData = WifiP2pDiscoveryConfig.readOuiKeyedDataList(in);
    }

    @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
    public static class Builder {
        private final int mScanType;
        private int mFrequencyMhz = 0;
        @NonNull
        private List<OuiKeyedData> mVendorData = new ArrayList<OuiKeyedData>();

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        public Builder(int scanType) {
            this.mScanType = scanType;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setFrequencyMhz(int frequencyMhz) {
            if (frequencyMhz <= 0) {
                throw new IllegalArgumentException("Frequency must be greater than 0");
            }
            this.mFrequencyMhz = frequencyMhz;
            return this;
        }

        @SystemApi
        @RequiresApi(value=35)
        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public Builder setVendorData(@NonNull List<OuiKeyedData> vendorData) {
            if (!SdkLevel.isAtLeastV()) {
                throw new UnsupportedOperationException();
            }
            if (vendorData == null) {
                throw new IllegalArgumentException("setVendorData received a null value");
            }
            this.mVendorData = vendorData;
            return this;
        }

        @FlaggedApi(value="com.android.wifi.flags.android_v_wifi_api")
        @NonNull
        public WifiP2pDiscoveryConfig build() {
            if (this.mScanType < 0 || this.mScanType > 2) {
                throw new IllegalArgumentException("Invalid scan type " + this.mScanType);
            }
            if (this.mScanType == 2 && this.mFrequencyMhz == 0) {
                throw new IllegalArgumentException("Scan type is single frequency, but no frequency was provided");
            }
            return new WifiP2pDiscoveryConfig(this.mScanType, this.mFrequencyMhz, this.mVendorData);
        }
    }
}

