/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.pps;

import android.annotation.NonNull;
import android.net.wifi.hotspot2.pps.UpdateParameter;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Policy
implements Parcelable {
    private static final String TAG = "Policy";
    private static final int MAX_EXCLUSION_SSIDS = 128;
    private static final int MAX_SSID_BYTES = 32;
    private static final int MAX_PORT_STRING_BYTES = 64;
    private static final int NULL_VALUE = -1;
    private long mMinHomeDownlinkBandwidth = Long.MIN_VALUE;
    private long mMinHomeUplinkBandwidth = Long.MIN_VALUE;
    private long mMinRoamingDownlinkBandwidth = Long.MIN_VALUE;
    private long mMinRoamingUplinkBandwidth = Long.MIN_VALUE;
    private String[] mExcludedSsidList = null;
    private Map<Integer, String> mRequiredProtoPortMap = null;
    private int mMaximumBssLoadValue = Integer.MIN_VALUE;
    private List<RoamingPartner> mPreferredRoamingPartnerList = null;
    private UpdateParameter mPolicyUpdate = null;
    @NonNull
    public static final Parcelable.Creator<Policy> CREATOR = new Parcelable.Creator<Policy>(){

        @Override
        public Policy createFromParcel(Parcel in) {
            Policy policy = new Policy();
            policy.setMinHomeDownlinkBandwidth(in.readLong());
            policy.setMinHomeUplinkBandwidth(in.readLong());
            policy.setMinRoamingDownlinkBandwidth(in.readLong());
            policy.setMinRoamingUplinkBandwidth(in.readLong());
            policy.setExcludedSsidList(in.createStringArray());
            policy.setRequiredProtoPortMap(this.readProtoPortMap(in));
            policy.setMaximumBssLoadValue(in.readInt());
            policy.setPreferredRoamingPartnerList(this.readRoamingPartnerList(in));
            policy.setPolicyUpdate((UpdateParameter)in.readParcelable(null));
            return policy;
        }

        public Policy[] newArray(int size) {
            return new Policy[size];
        }

        private Map<Integer, String> readProtoPortMap(Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            HashMap<Integer, String> protoPortMap = new HashMap<Integer, String>(size);
            for (int i = 0; i < size; ++i) {
                int key = in.readInt();
                String value = in.readString();
                protoPortMap.put(key, value);
            }
            return protoPortMap;
        }

        private List<RoamingPartner> readRoamingPartnerList(Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            ArrayList<RoamingPartner> partnerList = new ArrayList<RoamingPartner>();
            for (int i = 0; i < size; ++i) {
                partnerList.add((RoamingPartner)in.readParcelable(null));
            }
            return partnerList;
        }
    };

    public void setMinHomeDownlinkBandwidth(long minHomeDownlinkBandwidth) {
        this.mMinHomeDownlinkBandwidth = minHomeDownlinkBandwidth;
    }

    public long getMinHomeDownlinkBandwidth() {
        return this.mMinHomeDownlinkBandwidth;
    }

    public void setMinHomeUplinkBandwidth(long minHomeUplinkBandwidth) {
        this.mMinHomeUplinkBandwidth = minHomeUplinkBandwidth;
    }

    public long getMinHomeUplinkBandwidth() {
        return this.mMinHomeUplinkBandwidth;
    }

    public void setMinRoamingDownlinkBandwidth(long minRoamingDownlinkBandwidth) {
        this.mMinRoamingDownlinkBandwidth = minRoamingDownlinkBandwidth;
    }

    public long getMinRoamingDownlinkBandwidth() {
        return this.mMinRoamingDownlinkBandwidth;
    }

    public void setMinRoamingUplinkBandwidth(long minRoamingUplinkBandwidth) {
        this.mMinRoamingUplinkBandwidth = minRoamingUplinkBandwidth;
    }

    public long getMinRoamingUplinkBandwidth() {
        return this.mMinRoamingUplinkBandwidth;
    }

    public void setExcludedSsidList(String[] excludedSsidList) {
        this.mExcludedSsidList = excludedSsidList;
    }

    public String[] getExcludedSsidList() {
        return this.mExcludedSsidList;
    }

    public void setRequiredProtoPortMap(Map<Integer, String> requiredProtoPortMap) {
        this.mRequiredProtoPortMap = requiredProtoPortMap;
    }

    public Map<Integer, String> getRequiredProtoPortMap() {
        return this.mRequiredProtoPortMap;
    }

    public void setMaximumBssLoadValue(int maximumBssLoadValue) {
        this.mMaximumBssLoadValue = maximumBssLoadValue;
    }

    public int getMaximumBssLoadValue() {
        return this.mMaximumBssLoadValue;
    }

    public void setPreferredRoamingPartnerList(List<RoamingPartner> partnerList) {
        this.mPreferredRoamingPartnerList = partnerList;
    }

    public List<RoamingPartner> getPreferredRoamingPartnerList() {
        return this.mPreferredRoamingPartnerList;
    }

    public void setPolicyUpdate(UpdateParameter policyUpdate) {
        this.mPolicyUpdate = policyUpdate;
    }

    public UpdateParameter getPolicyUpdate() {
        return this.mPolicyUpdate;
    }

    public Policy() {
    }

    public Policy(Policy source) {
        if (source == null) {
            return;
        }
        this.mMinHomeDownlinkBandwidth = source.mMinHomeDownlinkBandwidth;
        this.mMinHomeUplinkBandwidth = source.mMinHomeUplinkBandwidth;
        this.mMinRoamingDownlinkBandwidth = source.mMinRoamingDownlinkBandwidth;
        this.mMinRoamingUplinkBandwidth = source.mMinRoamingUplinkBandwidth;
        this.mMaximumBssLoadValue = source.mMaximumBssLoadValue;
        if (source.mExcludedSsidList != null) {
            this.mExcludedSsidList = Arrays.copyOf(source.mExcludedSsidList, source.mExcludedSsidList.length);
        }
        if (source.mRequiredProtoPortMap != null) {
            this.mRequiredProtoPortMap = Collections.unmodifiableMap(source.mRequiredProtoPortMap);
        }
        if (source.mPreferredRoamingPartnerList != null) {
            this.mPreferredRoamingPartnerList = Collections.unmodifiableList(source.mPreferredRoamingPartnerList);
        }
        if (source.mPolicyUpdate != null) {
            this.mPolicyUpdate = new UpdateParameter(source.mPolicyUpdate);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mMinHomeDownlinkBandwidth);
        dest.writeLong(this.mMinHomeUplinkBandwidth);
        dest.writeLong(this.mMinRoamingDownlinkBandwidth);
        dest.writeLong(this.mMinRoamingUplinkBandwidth);
        dest.writeStringArray(this.mExcludedSsidList);
        Policy.writeProtoPortMap(dest, this.mRequiredProtoPortMap);
        dest.writeInt(this.mMaximumBssLoadValue);
        Policy.writeRoamingPartnerList(dest, flags, this.mPreferredRoamingPartnerList);
        dest.writeParcelable(this.mPolicyUpdate, flags);
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Policy)) {
            return false;
        }
        Policy that = (Policy)thatObject;
        return this.mMinHomeDownlinkBandwidth == that.mMinHomeDownlinkBandwidth && this.mMinHomeUplinkBandwidth == that.mMinHomeUplinkBandwidth && this.mMinRoamingDownlinkBandwidth == that.mMinRoamingDownlinkBandwidth && this.mMinRoamingUplinkBandwidth == that.mMinRoamingUplinkBandwidth && Arrays.equals(this.mExcludedSsidList, that.mExcludedSsidList) && (this.mRequiredProtoPortMap == null ? that.mRequiredProtoPortMap == null : this.mRequiredProtoPortMap.equals(that.mRequiredProtoPortMap)) && this.mMaximumBssLoadValue == that.mMaximumBssLoadValue && (this.mPreferredRoamingPartnerList == null ? that.mPreferredRoamingPartnerList == null : this.mPreferredRoamingPartnerList.equals(that.mPreferredRoamingPartnerList)) && (this.mPolicyUpdate == null ? that.mPolicyUpdate == null : this.mPolicyUpdate.equals(that.mPolicyUpdate));
    }

    public int hashCode() {
        return Objects.hash(this.mMinHomeDownlinkBandwidth, this.mMinHomeUplinkBandwidth, this.mMinRoamingDownlinkBandwidth, this.mMinRoamingUplinkBandwidth, Arrays.hashCode(this.mExcludedSsidList), this.mRequiredProtoPortMap, this.mMaximumBssLoadValue, this.mPreferredRoamingPartnerList, this.mPolicyUpdate);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MinHomeDownlinkBandwidth: ").append(this.mMinHomeDownlinkBandwidth).append("\n");
        builder.append("MinHomeUplinkBandwidth: ").append(this.mMinHomeUplinkBandwidth).append("\n");
        builder.append("MinRoamingDownlinkBandwidth: ").append(this.mMinRoamingDownlinkBandwidth).append("\n");
        builder.append("MinRoamingUplinkBandwidth: ").append(this.mMinRoamingUplinkBandwidth).append("\n");
        builder.append("ExcludedSSIDList: ").append(Arrays.toString(this.mExcludedSsidList)).append("\n");
        builder.append("RequiredProtoPortMap: ").append(this.mRequiredProtoPortMap).append("\n");
        builder.append("MaximumBSSLoadValue: ").append(this.mMaximumBssLoadValue).append("\n");
        builder.append("PreferredRoamingPartnerList: ").append(this.mPreferredRoamingPartnerList).append("\n");
        if (this.mPolicyUpdate != null) {
            builder.append("PolicyUpdate Begin ---\n");
            builder.append(this.mPolicyUpdate);
            builder.append("PolicyUpdate End ---\n");
        }
        return builder.toString();
    }

    public boolean validate() {
        if (this.mPolicyUpdate == null) {
            Log.d(TAG, "PolicyUpdate not specified");
            return false;
        }
        if (!this.mPolicyUpdate.validate()) {
            return false;
        }
        if (this.mExcludedSsidList != null) {
            if (this.mExcludedSsidList.length > 128) {
                Log.d(TAG, "SSID exclusion list size exceeded the max: " + this.mExcludedSsidList.length);
                return false;
            }
            for (String ssid : this.mExcludedSsidList) {
                if (ssid.getBytes(StandardCharsets.UTF_8).length <= 32) continue;
                Log.e(TAG, "Invalid SSID: " + (String)ssid);
                return false;
            }
        }
        if (this.mRequiredProtoPortMap != null) {
            for (Map.Entry entry : this.mRequiredProtoPortMap.entrySet()) {
                int protocol = (Integer)entry.getKey();
                if (protocol < 0 || protocol > 255) {
                    Log.e(TAG, "Invalid IP protocol: " + protocol);
                    return false;
                }
                String portNumber = (String)entry.getValue();
                if (portNumber.getBytes(StandardCharsets.UTF_8).length <= 64) continue;
                Log.e(TAG, "PortNumber string bytes exceeded the max: " + portNumber);
                return false;
            }
        }
        if (this.mPreferredRoamingPartnerList != null) {
            if (this.mPreferredRoamingPartnerList.size() > 16) {
                Log.e(TAG, "Number of the Preferred Roaming Partner exceed the limit");
                return false;
            }
            for (RoamingPartner roamingPartner : this.mPreferredRoamingPartnerList) {
                if (roamingPartner.validate()) continue;
                return false;
            }
        }
        return true;
    }

    private static void writeProtoPortMap(Parcel dest, Map<Integer, String> protoPortMap) {
        if (protoPortMap == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(protoPortMap.size());
        for (Map.Entry<Integer, String> entry : protoPortMap.entrySet()) {
            dest.writeInt(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    private static void writeRoamingPartnerList(Parcel dest, int flags, List<RoamingPartner> partnerList) {
        if (partnerList == null) {
            dest.writeInt(-1);
            return;
        }
        dest.writeInt(partnerList.size());
        for (RoamingPartner partner : partnerList) {
            dest.writeParcelable(partner, flags);
        }
    }

    public static class RoamingPartner
    implements Parcelable {
        private String mFqdn = null;
        private boolean mFqdnExactMatch = false;
        private int mPriority = Integer.MIN_VALUE;
        private String mCountries = null;
        @NonNull
        public static final Parcelable.Creator<RoamingPartner> CREATOR = new Parcelable.Creator<RoamingPartner>(){

            @Override
            public RoamingPartner createFromParcel(Parcel in) {
                RoamingPartner roamingPartner = new RoamingPartner();
                roamingPartner.setFqdn(in.readString());
                roamingPartner.setFqdnExactMatch(in.readInt() != 0);
                roamingPartner.setPriority(in.readInt());
                roamingPartner.setCountries(in.readString());
                return roamingPartner;
            }

            public RoamingPartner[] newArray(int size) {
                return new RoamingPartner[size];
            }
        };

        public void setFqdn(String fqdn) {
            this.mFqdn = fqdn;
        }

        public String getFqdn() {
            return this.mFqdn;
        }

        public void setFqdnExactMatch(boolean fqdnExactMatch) {
            this.mFqdnExactMatch = fqdnExactMatch;
        }

        public boolean getFqdnExactMatch() {
            return this.mFqdnExactMatch;
        }

        public void setPriority(int priority) {
            this.mPriority = priority;
        }

        public int getPriority() {
            return this.mPriority;
        }

        public void setCountries(String countries) {
            this.mCountries = countries;
        }

        public String getCountries() {
            return this.mCountries;
        }

        public RoamingPartner() {
        }

        public RoamingPartner(RoamingPartner source) {
            if (source != null) {
                this.mFqdn = source.mFqdn;
                this.mFqdnExactMatch = source.mFqdnExactMatch;
                this.mPriority = source.mPriority;
                this.mCountries = source.mCountries;
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mFqdn);
            dest.writeInt(this.mFqdnExactMatch ? 1 : 0);
            dest.writeInt(this.mPriority);
            dest.writeString(this.mCountries);
        }

        public boolean equals(Object thatObject) {
            if (this == thatObject) {
                return true;
            }
            if (!(thatObject instanceof RoamingPartner)) {
                return false;
            }
            RoamingPartner that = (RoamingPartner)thatObject;
            return TextUtils.equals(this.mFqdn, that.mFqdn) && this.mFqdnExactMatch == that.mFqdnExactMatch && this.mPriority == that.mPriority && TextUtils.equals(this.mCountries, that.mCountries);
        }

        public int hashCode() {
            return Objects.hash(this.mFqdn, this.mFqdnExactMatch, this.mPriority, this.mCountries);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FQDN: ").append(this.mFqdn).append("\n");
            builder.append("ExactMatch: ").append("mFqdnExactMatch").append("\n");
            builder.append("Priority: ").append(this.mPriority).append("\n");
            builder.append("Countries: ").append(this.mCountries).append("\n");
            return builder.toString();
        }

        public boolean validate() {
            if (TextUtils.isEmpty(this.mFqdn)) {
                Log.e(Policy.TAG, "Missing FQDN");
                return false;
            }
            if (this.mFqdn.getBytes(StandardCharsets.UTF_8).length > 255) {
                Log.e(Policy.TAG, "FQDN is too long");
                return false;
            }
            if (TextUtils.isEmpty(this.mCountries)) {
                Log.e(Policy.TAG, "Missing countries");
                return false;
            }
            if (this.mCountries.getBytes(StandardCharsets.UTF_8).length > 255) {
                Log.e(Policy.TAG, "country is too long");
                return false;
            }
            return true;
        }
    }
}

