/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.wifi.OuiKeyedData;
import android.net.wifi.aware.AwarePairingConfig;
import android.net.wifi.rtt.RangingResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IWifiAwareDiscoverySessionCallback
extends IInterface {
    public void onSessionStarted(int var1) throws RemoteException;

    public void onSessionConfigSuccess() throws RemoteException;

    public void onSessionConfigFail(int var1) throws RemoteException;

    public void onSessionTerminated(int var1) throws RemoteException;

    public void onSessionSuspendSucceeded() throws RemoteException;

    public void onSessionSuspendFail(int var1) throws RemoteException;

    public void onSessionResumeSucceeded() throws RemoteException;

    public void onSessionResumeFail(int var1) throws RemoteException;

    public void onMatch(int var1, byte[] var2, byte[] var3, int var4, byte[] var5, String var6, AwarePairingConfig var7, OuiKeyedData[] var8) throws RemoteException;

    public void onMatchWithDistance(int var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, String var7, AwarePairingConfig var8, OuiKeyedData[] var9) throws RemoteException;

    public void onMessageSendSuccess(int var1) throws RemoteException;

    public void onMessageSendFail(int var1, int var2) throws RemoteException;

    public void onMessageReceived(int var1, byte[] var2) throws RemoteException;

    public void onMatchExpired(int var1) throws RemoteException;

    public void onPairingSetupRequestReceived(int var1, int var2) throws RemoteException;

    public void onPairingSetupConfirmed(int var1, boolean var2, String var3) throws RemoteException;

    public void onPairingVerificationConfirmed(int var1, boolean var2, String var3) throws RemoteException;

    public void onBootstrappingVerificationConfirmed(int var1, boolean var2, int var3) throws RemoteException;

    public void onRangingResultsReceived(List<RangingResult> var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IWifiAwareDiscoverySessionCallback {
        public static final String DESCRIPTOR = "android.net.wifi.aware.IWifiAwareDiscoverySessionCallback";
        static final int TRANSACTION_onSessionStarted = 1;
        static final int TRANSACTION_onSessionConfigSuccess = 2;
        static final int TRANSACTION_onSessionConfigFail = 3;
        static final int TRANSACTION_onSessionTerminated = 4;
        static final int TRANSACTION_onSessionSuspendSucceeded = 5;
        static final int TRANSACTION_onSessionSuspendFail = 6;
        static final int TRANSACTION_onSessionResumeSucceeded = 7;
        static final int TRANSACTION_onSessionResumeFail = 8;
        static final int TRANSACTION_onMatch = 9;
        static final int TRANSACTION_onMatchWithDistance = 10;
        static final int TRANSACTION_onMessageSendSuccess = 11;
        static final int TRANSACTION_onMessageSendFail = 12;
        static final int TRANSACTION_onMessageReceived = 13;
        static final int TRANSACTION_onMatchExpired = 14;
        static final int TRANSACTION_onPairingSetupRequestReceived = 15;
        static final int TRANSACTION_onPairingSetupConfirmed = 16;
        static final int TRANSACTION_onPairingVerificationConfirmed = 17;
        static final int TRANSACTION_onBootstrappingVerificationConfirmed = 18;
        static final int TRANSACTION_onRangingResultsReceived = 19;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiAwareDiscoverySessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiAwareDiscoverySessionCallback) {
                return (IWifiAwareDiscoverySessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionStarted";
                }
                case 2: {
                    return "onSessionConfigSuccess";
                }
                case 3: {
                    return "onSessionConfigFail";
                }
                case 4: {
                    return "onSessionTerminated";
                }
                case 5: {
                    return "onSessionSuspendSucceeded";
                }
                case 6: {
                    return "onSessionSuspendFail";
                }
                case 7: {
                    return "onSessionResumeSucceeded";
                }
                case 8: {
                    return "onSessionResumeFail";
                }
                case 9: {
                    return "onMatch";
                }
                case 10: {
                    return "onMatchWithDistance";
                }
                case 11: {
                    return "onMessageSendSuccess";
                }
                case 12: {
                    return "onMessageSendFail";
                }
                case 13: {
                    return "onMessageReceived";
                }
                case 14: {
                    return "onMatchExpired";
                }
                case 15: {
                    return "onPairingSetupRequestReceived";
                }
                case 16: {
                    return "onPairingSetupConfirmed";
                }
                case 17: {
                    return "onPairingVerificationConfirmed";
                }
                case 18: {
                    return "onBootstrappingVerificationConfirmed";
                }
                case 19: {
                    return "onRangingResultsReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.onSessionStarted(_arg0);
                    break;
                }
                case 2: {
                    this.onSessionConfigSuccess();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    this.onSessionConfigFail(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.onSessionTerminated(_arg0);
                    break;
                }
                case 5: {
                    this.onSessionSuspendSucceeded();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    this.onSessionSuspendFail(_arg0);
                    break;
                }
                case 7: {
                    this.onSessionResumeSucceeded();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    this.onSessionResumeFail(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    byte[] _arg4 = data.createByteArray();
                    String _arg5 = data.readString();
                    AwarePairingConfig _arg6 = data.readTypedObject(AwarePairingConfig.CREATOR);
                    OuiKeyedData[] _arg7 = data.createTypedArray(OuiKeyedData.CREATOR);
                    this.onMatch(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    byte[] _arg5 = data.createByteArray();
                    String _arg6 = data.readString();
                    AwarePairingConfig _arg7 = data.readTypedObject(AwarePairingConfig.CREATOR);
                    OuiKeyedData[] _arg8 = data.createTypedArray(OuiKeyedData.CREATOR);
                    this.onMatchWithDistance(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    this.onMessageSendSuccess(_arg0);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onMessageSendFail(_arg0, _arg1);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    this.onMessageReceived(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    this.onMatchExpired(_arg0);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onPairingSetupRequestReceived(_arg0, _arg1);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    this.onPairingSetupConfirmed(_arg0, _arg1, _arg2);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    String _arg2 = data.readString();
                    this.onPairingVerificationConfirmed(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    this.onBootstrappingVerificationConfirmed(_arg0, _arg1, _arg2);
                    break;
                }
                case 19: {
                    ArrayList<RangingResult> _arg0 = data.createTypedArrayList(RangingResult.CREATOR);
                    this.onRangingResultsReceived(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 18;
        }

        private static class Proxy
        implements IWifiAwareDiscoverySessionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStarted(int discoverySessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(discoverySessionId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSessionConfigSuccess() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionConfigFail(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionTerminated(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSessionSuspendSucceeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionSuspendFail(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onSessionResumeSucceeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionResumeFail(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMatch(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, OuiKeyedData[] vendorData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeByteArray(serviceSpecificInfo);
                    _data.writeByteArray(matchFilter);
                    _data.writeInt(peerCipherSuite);
                    _data.writeByteArray(scid);
                    _data.writeString(pairingAlias);
                    _data.writeTypedObject(pairingConfig, 0);
                    _data.writeTypedArray(vendorData, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMatchWithDistance(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int distanceMm, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, OuiKeyedData[] vendorData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeByteArray(serviceSpecificInfo);
                    _data.writeByteArray(matchFilter);
                    _data.writeInt(distanceMm);
                    _data.writeInt(peerCipherSuite);
                    _data.writeByteArray(scid);
                    _data.writeString(pairingAlias);
                    _data.writeTypedObject(pairingConfig, 0);
                    _data.writeTypedArray(vendorData, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageSendSuccess(int messageId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageId);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageSendFail(int messageId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeByteArray(message);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMatchExpired(int peerId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPairingSetupRequestReceived(int peerId, int requestId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeInt(requestId);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPairingSetupConfirmed(int peerId, boolean accept, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeBoolean(accept);
                    _data.writeString(alias);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPairingVerificationConfirmed(int peerId, boolean accept, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeBoolean(accept);
                    _data.writeString(alias);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBootstrappingVerificationConfirmed(int peerId, boolean accept, int method) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(peerId);
                    _data.writeBoolean(accept);
                    _data.writeInt(method);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRangingResultsReceived(List<RangingResult> rangingResults) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, rangingResults, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiAwareDiscoverySessionCallback {
        @Override
        public void onSessionStarted(int discoverySessionId) throws RemoteException {
        }

        @Override
        public void onSessionConfigSuccess() throws RemoteException {
        }

        @Override
        public void onSessionConfigFail(int reason) throws RemoteException {
        }

        @Override
        public void onSessionTerminated(int reason) throws RemoteException {
        }

        @Override
        public void onSessionSuspendSucceeded() throws RemoteException {
        }

        @Override
        public void onSessionSuspendFail(int reason) throws RemoteException {
        }

        @Override
        public void onSessionResumeSucceeded() throws RemoteException {
        }

        @Override
        public void onSessionResumeFail(int reason) throws RemoteException {
        }

        @Override
        public void onMatch(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, OuiKeyedData[] vendorData) throws RemoteException {
        }

        @Override
        public void onMatchWithDistance(int peerId, byte[] serviceSpecificInfo, byte[] matchFilter, int distanceMm, int peerCipherSuite, byte[] scid, String pairingAlias, AwarePairingConfig pairingConfig, OuiKeyedData[] vendorData) throws RemoteException {
        }

        @Override
        public void onMessageSendSuccess(int messageId) throws RemoteException {
        }

        @Override
        public void onMessageSendFail(int messageId, int reason) throws RemoteException {
        }

        @Override
        public void onMessageReceived(int peerId, byte[] message) throws RemoteException {
        }

        @Override
        public void onMatchExpired(int peerId) throws RemoteException {
        }

        @Override
        public void onPairingSetupRequestReceived(int peerId, int requestId) throws RemoteException {
        }

        @Override
        public void onPairingSetupConfirmed(int peerId, boolean accept, String alias) throws RemoteException {
        }

        @Override
        public void onPairingVerificationConfirmed(int peerId, boolean accept, String alias) throws RemoteException {
        }

        @Override
        public void onBootstrappingVerificationConfirmed(int peerId, boolean accept, int method) throws RemoteException {
        }

        @Override
        public void onRangingResultsReceived(List<RangingResult> rangingResults) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

