/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiLowLatencyLockListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiLowLatencyLockListener";

    public void onActivatedStateChanged(boolean var1) throws RemoteException;

    public void onOwnershipChanged(int[] var1) throws RemoteException;

    public void onActiveUsersChanged(int[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiLowLatencyLockListener {
        static final int TRANSACTION_onActivatedStateChanged = 1;
        static final int TRANSACTION_onOwnershipChanged = 2;
        static final int TRANSACTION_onActiveUsersChanged = 3;

        public Stub() {
            this.attachInterface(this, IWifiLowLatencyLockListener.DESCRIPTOR);
        }

        public static IWifiLowLatencyLockListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiLowLatencyLockListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiLowLatencyLockListener) {
                return (IWifiLowLatencyLockListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onActivatedStateChanged";
                }
                case 2: {
                    return "onOwnershipChanged";
                }
                case 3: {
                    return "onActiveUsersChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiLowLatencyLockListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    this.onActivatedStateChanged(_arg0);
                    break;
                }
                case 2: {
                    int[] _arg0 = data.createIntArray();
                    this.onOwnershipChanged(_arg0);
                    break;
                }
                case 3: {
                    int[] _arg0 = data.createIntArray();
                    this.onActiveUsersChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IWifiLowLatencyLockListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiLowLatencyLockListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivatedStateChanged(boolean activated) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiLowLatencyLockListener.DESCRIPTOR);
                    _data.writeBoolean(activated);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOwnershipChanged(int[] ownerUids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiLowLatencyLockListener.DESCRIPTOR);
                    _data.writeIntArray(ownerUids);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActiveUsersChanged(int[] activeUids) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiLowLatencyLockListener.DESCRIPTOR);
                    _data.writeIntArray(activeUids);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiLowLatencyLockListener {
        @Override
        public void onActivatedStateChanged(boolean activated) throws RemoteException {
        }

        @Override
        public void onOwnershipChanged(int[] ownerUids) throws RemoteException {
        }

        @Override
        public void onActiveUsersChanged(int[] activeUids) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

