/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiBands;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IWifiBandsListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IWifiBandsListener";

    public void onResult(WifiBands[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiBandsListener {
        static final int TRANSACTION_onResult = 1;

        public Stub() {
            this.attachInterface(this, IWifiBandsListener.DESCRIPTOR);
        }

        public static IWifiBandsListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWifiBandsListener.DESCRIPTOR);
            if (iin != null && iin instanceof IWifiBandsListener) {
                return (IWifiBandsListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWifiBandsListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    WifiBands[] _arg0 = data.createTypedArray(WifiBands.CREATOR);
                    this.onResult(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWifiBandsListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWifiBandsListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(WifiBands[] supportedBands) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWifiBandsListener.DESCRIPTOR);
                    _data.writeTypedArray(supportedBands, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWifiBandsListener {
        @Override
        public void onResult(WifiBands[] supportedBands) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

