/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.ScanResult;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPnoScanResultsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IPnoScanResultsCallback";

    public void onScanResultsAvailable(List<ScanResult> var1) throws RemoteException;

    public void onRegisterSuccess() throws RemoteException;

    public void onRegisterFailed(int var1) throws RemoteException;

    public void onRemoved(int var1) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IPnoScanResultsCallback {
        static final int TRANSACTION_onScanResultsAvailable = 1;
        static final int TRANSACTION_onRegisterSuccess = 2;
        static final int TRANSACTION_onRegisterFailed = 3;
        static final int TRANSACTION_onRemoved = 4;

        public Stub() {
            this.attachInterface(this, IPnoScanResultsCallback.DESCRIPTOR);
        }

        public static IPnoScanResultsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPnoScanResultsCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IPnoScanResultsCallback) {
                return (IPnoScanResultsCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onScanResultsAvailable";
                }
                case 2: {
                    return "onRegisterSuccess";
                }
                case 3: {
                    return "onRegisterFailed";
                }
                case 4: {
                    return "onRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPnoScanResultsCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    this.onScanResultsAvailable(_arg0);
                    break;
                }
                case 2: {
                    this.onRegisterSuccess();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    this.onRegisterFailed(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    this.onRemoved(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IPnoScanResultsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPnoScanResultsCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onScanResultsAvailable(List<ScanResult> scanResults) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPnoScanResultsCallback.DESCRIPTOR);
                    _Parcel.writeTypedList(_data, scanResults, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRegisterSuccess() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPnoScanResultsCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegisterFailed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPnoScanResultsCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPnoScanResultsCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPnoScanResultsCallback {
        @Override
        public void onScanResultsAvailable(List<ScanResult> scanResults) throws RemoteException {
        }

        @Override
        public void onRegisterSuccess() throws RemoteException {
        }

        @Override
        public void onRegisterFailed(int reason) throws RemoteException {
        }

        @Override
        public void onRemoved(int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

