/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.MacAddress;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;

public interface IMacAddressListListener
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.IMacAddressListListener";

    public void onResult(ParceledListSlice<MacAddress> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMacAddressListListener {
        static final int TRANSACTION_onResult = 1;

        public Stub() {
            this.attachInterface(this, IMacAddressListListener.DESCRIPTOR);
        }

        public static IMacAddressListListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMacAddressListListener.DESCRIPTOR);
            if (iin != null && iin instanceof IMacAddressListListener) {
                return (IMacAddressListListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMacAddressListListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    this.onResult(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IMacAddressListListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMacAddressListListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(ParceledListSlice<MacAddress> value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMacAddressListListener.DESCRIPTOR);
                    _data.writeTypedObject(value, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMacAddressListListener {
        @Override
        public void onResult(ParceledListSlice<MacAddress> value) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

