/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Objects;

@SystemApi
@RequiresApi(value=31)
public class CoexUnsafeChannel
implements Parcelable {
    public static final int POWER_CAP_NONE = Integer.MAX_VALUE;
    private int mBand;
    private int mChannel;
    private int mPowerCapDbm;
    @NonNull
    public static final Parcelable.Creator<CoexUnsafeChannel> CREATOR = new Parcelable.Creator<CoexUnsafeChannel>(){

        @Override
        public CoexUnsafeChannel createFromParcel(Parcel in) {
            int band = in.readInt();
            int channel = in.readInt();
            int powerCapDbm = in.readInt();
            return new CoexUnsafeChannel(band, channel, powerCapDbm);
        }

        public CoexUnsafeChannel[] newArray(int size) {
            return new CoexUnsafeChannel[size];
        }
    };

    public CoexUnsafeChannel(int band, int channel) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        this.mBand = band;
        this.mChannel = channel;
        this.mPowerCapDbm = Integer.MAX_VALUE;
    }

    public CoexUnsafeChannel(int band, int channel, int powerCapDbm) {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        this.mBand = band;
        this.mChannel = channel;
        this.mPowerCapDbm = powerCapDbm;
    }

    public int getBand() {
        return this.mBand;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public int getPowerCapDbm() {
        return this.mPowerCapDbm;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoexUnsafeChannel that = (CoexUnsafeChannel)o;
        return this.mBand == that.mBand && this.mChannel == that.mChannel && this.mPowerCapDbm == that.mPowerCapDbm;
    }

    public int hashCode() {
        return Objects.hash(this.mBand, this.mChannel, this.mPowerCapDbm);
    }

    public String toString() {
        StringBuilder sj = new StringBuilder("CoexUnsafeChannel{");
        if (this.mBand == 1) {
            sj.append("2.4GHz");
        } else if (this.mBand == 2) {
            sj.append("5GHz");
        } else if (this.mBand == 8) {
            sj.append("6GHz");
        } else {
            sj.append("UNKNOWN BAND");
        }
        sj.append(", ").append(this.mChannel);
        if (this.mPowerCapDbm != Integer.MAX_VALUE) {
            sj.append(", ").append(this.mPowerCapDbm).append("dBm");
        }
        sj.append('}');
        return sj.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mBand);
        dest.writeInt(this.mChannel);
        dest.writeInt(this.mPowerCapDbm);
    }
}

