/*
 * Decompiled with CFR 0.152.
 */
package android.net.thread;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.net.thread.flags.configuration_enabled")
public class ThreadConfiguration
implements Parcelable {
    private final boolean mBorderRouterEnabled;
    private final boolean mNat64Enabled;
    private final boolean mDhcpv6PdEnabled;
    @NonNull
    public static final Parcelable.Creator<ThreadConfiguration> CREATOR = new Parcelable.Creator<ThreadConfiguration>(){

        @Override
        public ThreadConfiguration createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setBorderRouterEnabled(in.readBoolean());
            builder.setNat64Enabled(in.readBoolean());
            builder.setDhcpv6PdEnabled(in.readBoolean());
            return builder.build();
        }

        public ThreadConfiguration[] newArray(int size) {
            return new ThreadConfiguration[size];
        }
    };

    private ThreadConfiguration(Builder builder) {
        this(builder.mBorderRouterEnabled, builder.mNat64Enabled, builder.mDhcpv6PdEnabled);
    }

    private ThreadConfiguration(boolean borderRouterEnabled, boolean nat64Enabled, boolean dhcpv6PdEnabled) {
        this.mBorderRouterEnabled = borderRouterEnabled;
        this.mNat64Enabled = nat64Enabled;
        this.mDhcpv6PdEnabled = dhcpv6PdEnabled;
    }

    public boolean isBorderRouterEnabled() {
        return this.mBorderRouterEnabled;
    }

    public boolean isNat64Enabled() {
        return this.mNat64Enabled;
    }

    public boolean isDhcpv6PdEnabled() {
        return this.mDhcpv6PdEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ThreadConfiguration)) {
            return false;
        }
        ThreadConfiguration otherConfig = (ThreadConfiguration)other;
        return this.mBorderRouterEnabled == otherConfig.mBorderRouterEnabled && this.mNat64Enabled == otherConfig.mNat64Enabled && this.mDhcpv6PdEnabled == otherConfig.mDhcpv6PdEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.mBorderRouterEnabled, this.mNat64Enabled, this.mDhcpv6PdEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("borderRouterEnabled=").append(this.mBorderRouterEnabled);
        sb.append(", nat64Enabled=").append(this.mNat64Enabled);
        sb.append(", dhcpv6PdEnabled=").append(this.mDhcpv6PdEnabled);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mBorderRouterEnabled);
        dest.writeBoolean(this.mNat64Enabled);
        dest.writeBoolean(this.mDhcpv6PdEnabled);
    }

    @SystemApi
    @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
    public static class Builder {
        private boolean mBorderRouterEnabled = true;
        private boolean mNat64Enabled = false;
        private boolean mDhcpv6PdEnabled = false;

        @SystemApi
        @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
        public Builder() {
        }

        @SystemApi
        @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
        public Builder(@NonNull ThreadConfiguration config) {
            Objects.requireNonNull(config);
            this.mBorderRouterEnabled = config.mBorderRouterEnabled;
            this.mNat64Enabled = config.mNat64Enabled;
            this.mDhcpv6PdEnabled = config.mDhcpv6PdEnabled;
        }

        @NonNull
        public Builder setBorderRouterEnabled(boolean enabled) {
            this.mBorderRouterEnabled = enabled;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
        @NonNull
        public Builder setNat64Enabled(boolean enabled) {
            this.mNat64Enabled = enabled;
            return this;
        }

        @NonNull
        public Builder setDhcpv6PdEnabled(boolean enabled) {
            this.mDhcpv6PdEnabled = enabled;
            return this;
        }

        @SystemApi
        @FlaggedApi(value="com.android.net.thread.flags.set_nat64_configuration_enabled")
        @NonNull
        public ThreadConfiguration build() {
            return new ThreadConfiguration(this);
        }
    }
}

