/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.nsd.NsdServiceInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.Objects;

@FlaggedApi(value="com.android.net.flags.ipv6_over_ble")
public class AdvertisingRequest
implements Parcelable {
    public static final long NSD_ADVERTISING_UPDATE_ONLY = 1L;
    public static final long FLAG_SKIP_PROBING = 2L;
    public static final long FLAG_SKIP_SUBTYPE_ANNOUNCEMENTS = Long.MIN_VALUE;
    public static final long FLAG_OFFLOAD_ONLY = 0x4000000000000000L;
    @NonNull
    public static final Parcelable.Creator<AdvertisingRequest> CREATOR = new Parcelable.Creator<AdvertisingRequest>(){

        @Override
        public AdvertisingRequest createFromParcel(Parcel in) {
            NsdServiceInfo serviceInfo = in.readParcelable(NsdServiceInfo.class.getClassLoader(), NsdServiceInfo.class);
            int protocolType = in.readInt();
            long advertiseConfig = in.readLong();
            long ttlSeconds = in.readLong();
            Duration ttl = ttlSeconds < 0L ? null : Duration.ofSeconds(ttlSeconds);
            return new AdvertisingRequest(serviceInfo, protocolType, advertiseConfig, ttl);
        }

        public AdvertisingRequest[] newArray(int size) {
            return new AdvertisingRequest[size];
        }
    };
    @NonNull
    private final NsdServiceInfo mServiceInfo;
    private final int mProtocolType;
    private final long mAdvertisingConfig;
    @Nullable
    private final Duration mTtl;

    private AdvertisingRequest(@NonNull NsdServiceInfo serviceInfo, int protocolType, long advertisingConfig, @NonNull Duration ttl) {
        this.mServiceInfo = serviceInfo;
        this.mProtocolType = protocolType;
        this.mAdvertisingConfig = advertisingConfig;
        this.mTtl = ttl;
    }

    @NonNull
    public NsdServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public int getProtocolType() {
        return this.mProtocolType;
    }

    public long getFlags() {
        return this.mAdvertisingConfig;
    }

    @Nullable
    public Duration getTtl() {
        return this.mTtl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("serviceInfo: ").append(this.mServiceInfo).append(", protocolType: ").append(this.mProtocolType).append(", advertisingConfig: ").append(this.mAdvertisingConfig).append(", ttl: ").append(this.mTtl);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdvertisingRequest)) {
            return false;
        }
        AdvertisingRequest otherRequest = (AdvertisingRequest)other;
        return this.mServiceInfo.equals(otherRequest.mServiceInfo) && this.mProtocolType == otherRequest.mProtocolType && this.mAdvertisingConfig == otherRequest.mAdvertisingConfig && Objects.equals(this.mTtl, otherRequest.mTtl);
    }

    public int hashCode() {
        return Objects.hash(this.mServiceInfo, this.mProtocolType, this.mAdvertisingConfig, this.mTtl);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mServiceInfo, flags);
        dest.writeInt(this.mProtocolType);
        dest.writeLong(this.mAdvertisingConfig);
        dest.writeLong(this.mTtl == null ? -1L : this.mTtl.getSeconds());
    }

    @FlaggedApi(value="com.android.net.flags.ipv6_over_ble")
    public static class Builder {
        @NonNull
        private final NsdServiceInfo mServiceInfo;
        private int mProtocolType;
        private long mAdvertisingConfig;
        @Nullable
        private Duration mTtl;

        public Builder(@NonNull NsdServiceInfo serviceInfo, int protocolType) {
            this.mServiceInfo = serviceInfo;
            this.mProtocolType = protocolType;
        }

        public Builder(@NonNull NsdServiceInfo serviceInfo) {
            this(serviceInfo, 1);
        }

        @NonNull
        public Builder setFlags(long flags) {
            this.mAdvertisingConfig = flags;
            return this;
        }

        @NonNull
        public Builder setTtl(@Nullable Duration ttl) {
            if (ttl == null) {
                this.mTtl = null;
                return this;
            }
            long ttlSeconds = ttl.getSeconds();
            if (ttlSeconds < 0L || ttlSeconds > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("ttlSeconds exceeds the allowed range (value = " + ttlSeconds + ", allowedRanged = [0, 0xffffffffL])");
            }
            this.mTtl = Duration.ofSeconds(ttlSeconds);
            return this;
        }

        @NonNull
        public Builder setProtocolType(int protocolType) {
            this.mProtocolType = protocolType;
            return this;
        }

        @NonNull
        public AdvertisingRequest build() {
            return new AdvertisingRequest(this.mServiceInfo, this.mProtocolType, this.mAdvertisingConfig, this.mTtl);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface AdvertisingConfig {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdvertisingFlags {
    }
}

