/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.net.ipsec.ike.ChildSaProposal;
import android.net.ipsec.ike.ChildSessionParams;
import android.net.ipsec.ike.IkeTrafficSelector;
import android.os.PersistableBundle;
import java.util.Objects;

public class TransportModeChildSessionParams
extends ChildSessionParams {
    private TransportModeChildSessionParams(IkeTrafficSelector[] inboundTs, IkeTrafficSelector[] outboundTs, ChildSaProposal[] proposals, int hardLifetimeSec, int softLifetimeSec) {
        super(inboundTs, outboundTs, proposals, hardLifetimeSec, softLifetimeSec, true);
    }

    @NonNull
    public static TransportModeChildSessionParams fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle not provided");
        Builder builder = new Builder();
        for (ChildSaProposal p : TransportModeChildSessionParams.getProposalsFromPersistableBundle(in)) {
            builder.addSaProposal(p);
        }
        for (IkeTrafficSelector ts : TransportModeChildSessionParams.getTsFromPersistableBundle(in, "mInboundTrafficSelectors")) {
            builder.addInboundTrafficSelectors(ts);
        }
        for (IkeTrafficSelector ts : TransportModeChildSessionParams.getTsFromPersistableBundle(in, "mOutboundTrafficSelectors")) {
            builder.addOutboundTrafficSelectors(ts);
        }
        builder.setLifetimeSeconds(in.getInt("mHardLifetimeSec"), in.getInt("mSoftLifetimeSec"));
        return builder.build();
    }

    public static class Builder
    extends ChildSessionParams.Builder {
        public Builder() {
        }

        public Builder(@NonNull TransportModeChildSessionParams childParams) {
            super(childParams);
        }

        @Deprecated
        @SystemApi
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addSaProposal(@NonNull ChildSaProposal proposal) {
            return this.addChildSaProposal(proposal);
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addChildSaProposal(@NonNull ChildSaProposal proposal) {
            Objects.requireNonNull(proposal, "Required argument not provided");
            this.addProposal(proposal);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addInboundTrafficSelectors(@NonNull IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addInboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addOutboundTrafficSelectors(@NonNull IkeTrafficSelector trafficSelector) {
            Objects.requireNonNull(trafficSelector, "Required argument not provided");
            this.addOutboundTs(trafficSelector);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setLifetimeSeconds(int hardLifetimeSeconds, int softLifetimeSeconds) {
            this.validateAndSetLifetime(hardLifetimeSeconds, softLifetimeSeconds);
            this.mHardLifetimeSec = hardLifetimeSeconds;
            this.mSoftLifetimeSec = softLifetimeSeconds;
            return this;
        }

        @NonNull
        public TransportModeChildSessionParams build() {
            this.addDefaultTsIfNotConfigured();
            this.validateOrThrow();
            return new TransportModeChildSessionParams(this.mInboundTsList.toArray(new IkeTrafficSelector[0]), this.mOutboundTsList.toArray(new IkeTrafficSelector[0]), this.mSaProposalList.toArray(new ChildSaProposal[0]), this.mHardLifetimeSec, this.mSoftLifetimeSec);
        }
    }
}

