/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class IkeFqdnIdentification
extends IkeIdentification {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final String FQDN_KEY = "fqdn";
    @NonNull
    public final String fqdn;

    public IkeFqdnIdentification(byte[] fqdnBytes) {
        super(2);
        this.fqdn = new String(fqdnBytes, ASCII);
    }

    public IkeFqdnIdentification(@NonNull String fqdn) {
        super(2);
        if (!ASCII.newEncoder().canEncode(fqdn)) {
            throw new IllegalArgumentException("Non US-ASCII character set used");
        }
        this.fqdn = fqdn;
    }

    @NonNull
    public static IkeFqdnIdentification fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        return new IkeFqdnIdentification(in.getString(FQDN_KEY));
    }

    @Override
    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putString(FQDN_KEY, this.fqdn);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.fqdn);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeFqdnIdentification)) {
            return false;
        }
        return this.fqdn.equals(((IkeFqdnIdentification)o).fqdn);
    }

    @Override
    public String getIdTypeString() {
        return "FQDN";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        this.validateEndCertSanOrThrow(endCert, 2, this.fqdn);
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.fqdn.getBytes(ASCII);
    }
}

