/*
 * Decompiled with CFR 0.152.
 */
package android.net.ipsec.ike;

import android.annotation.NonNull;
import android.net.ipsec.ike.IkeIdentification;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.os.PersistableBundle;
import com.android.internal.net.vcn.util.PersistableBundleUtils;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class IkeDerAsn1DnIdentification
extends IkeIdentification {
    private static final String DER_ASN1_DN_KEY = "derAsn1Dn";
    @NonNull
    public final X500Principal derAsn1Dn;

    public IkeDerAsn1DnIdentification(byte[] derAsn1DnBytes) throws AuthenticationFailedException {
        super(9);
        Objects.requireNonNull(derAsn1DnBytes, "derAsn1DnBytes not provided");
        try {
            this.derAsn1Dn = new X500Principal(derAsn1DnBytes);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationFailedException(e);
        }
    }

    public IkeDerAsn1DnIdentification(@NonNull X500Principal derAsn1Dn) {
        super(9);
        Objects.requireNonNull(derAsn1Dn, "derAsn1Dn not provided");
        this.derAsn1Dn = derAsn1Dn;
    }

    @NonNull
    public static IkeDerAsn1DnIdentification fromPersistableBundle(@NonNull PersistableBundle in) {
        Objects.requireNonNull(in, "PersistableBundle is null");
        PersistableBundle dnBundle = in.getPersistableBundle(DER_ASN1_DN_KEY);
        Objects.requireNonNull(dnBundle, "ASN1 DN bundle is null");
        return new IkeDerAsn1DnIdentification(new X500Principal(PersistableBundleUtils.toByteArray(dnBundle)));
    }

    @Override
    @NonNull
    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = super.toPersistableBundle();
        result.putPersistableBundle(DER_ASN1_DN_KEY, PersistableBundleUtils.fromByteArray(this.derAsn1Dn.getEncoded()));
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.idType, this.derAsn1Dn);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IkeDerAsn1DnIdentification)) {
            return false;
        }
        return this.derAsn1Dn.equals(((IkeDerAsn1DnIdentification)o).derAsn1Dn);
    }

    @Override
    public String getIdTypeString() {
        return "DER ASN.1 DN";
    }

    @Override
    public void validateEndCertIdOrThrow(X509Certificate endCert) throws AuthenticationFailedException {
        if (!this.derAsn1Dn.equals(endCert.getSubjectX500Principal())) {
            throw new AuthenticationFailedException("End cert subject DN and DER ASN1 DN ID mismtached");
        }
    }

    @Override
    public byte[] getEncodedIdData() {
        return this.derAsn1Dn.getEncoded();
    }
}

