/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HeaderBlock;
import android.net.http.HeaderBlockImpl;
import android.net.http.UrlRequest;
import android.net.http.UrlRequestStatusListenerWrapper;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class UrlRequestWrapper
extends UrlRequest {
    private final android.net.connectivity.org.chromium.net.UrlRequest backend;
    private String mHttpMethod = "GET";
    private int mPriority = 3;
    private boolean mHasTrafficStatsTag;
    private int mTrafficStatsTag;
    private boolean mHasTrafficStatsUid;
    private int mTrafficStatsUid;
    private final boolean mCacheDisabled;
    private final boolean mDirectExecutorAllowed;
    private final List<Map.Entry<String, String>> mHeadersList;
    private HeaderBlock mHeaders;

    public UrlRequestWrapper(android.net.connectivity.org.chromium.net.UrlRequest backend, boolean cacheDisabled, boolean directExecutorAllowed) {
        this.backend = backend;
        this.mCacheDisabled = cacheDisabled;
        this.mDirectExecutorAllowed = directExecutorAllowed;
        this.mHeadersList = new ArrayList<Map.Entry<String, String>>();
        this.mHeaders = new HeaderBlockImpl(this.mHeadersList);
    }

    public UrlRequestWrapper(android.net.connectivity.org.chromium.net.UrlRequest backend, String httpMethod, boolean hasTrafficStatsTag, int trafficStatsTag, boolean hasTrafficStatsUid, int trafficStatsUid, int priority, HeaderBlock headerBlock, boolean cacheDisabled, boolean directExecutorAllowed) {
        this(backend, cacheDisabled, directExecutorAllowed);
        this.mHttpMethod = httpMethod;
        this.mHasTrafficStatsTag = hasTrafficStatsTag;
        this.mHasTrafficStatsUid = hasTrafficStatsUid;
        this.mTrafficStatsTag = trafficStatsTag;
        this.mTrafficStatsUid = trafficStatsUid;
        this.mHeaders = headerBlock;
        this.mPriority = priority;
    }

    @Override
    public void start() {
        this.backend.start();
    }

    @Override
    public void followRedirect() {
        this.backend.followRedirect();
    }

    @Override
    public void read(ByteBuffer buffer) {
        this.backend.read(buffer);
    }

    @Override
    public void cancel() {
        this.backend.cancel();
    }

    @Override
    public boolean isDone() {
        return this.backend.isDone();
    }

    @Override
    public void getStatus(UrlRequest.StatusListener listener) {
        this.backend.getStatus(new UrlRequestStatusListenerWrapper(listener));
    }

    @Override
    public String getHttpMethod() {
        return this.mHttpMethod;
    }

    @Override
    public HeaderBlock getHeaders() {
        return this.mHeaders;
    }

    @Override
    public boolean isCacheDisabled() {
        return this.mCacheDisabled;
    }

    @Override
    public boolean isDirectExecutorAllowed() {
        return this.mDirectExecutorAllowed;
    }

    @Override
    public int getPriority() {
        return this.mPriority;
    }

    @Override
    public boolean hasTrafficStatsTag() {
        return this.mHasTrafficStatsTag;
    }

    @Override
    public int getTrafficStatsTag() {
        if (!this.hasTrafficStatsTag()) {
            throw new IllegalStateException("TrafficStatsTag is not set");
        }
        return this.mTrafficStatsTag;
    }

    @Override
    public boolean hasTrafficStatsUid() {
        return this.mHasTrafficStatsUid;
    }

    @Override
    public int getTrafficStatsUid() {
        if (!this.hasTrafficStatsUid()) {
            throw new IllegalStateException("TrafficStatsUid is not set");
        }
        return this.mTrafficStatsUid;
    }

    void setHttpMethod(String httpMethod) {
        this.mHttpMethod = httpMethod;
    }

    void setPriority(int priority) {
        this.mPriority = priority;
    }

    void setTrafficStatsTag(int trafficStatsTag) {
        this.mHasTrafficStatsTag = true;
        this.mTrafficStatsTag = trafficStatsTag;
    }

    void setTrafficStatsUid(int trafficStatsUid) {
        this.mHasTrafficStatsUid = true;
        this.mTrafficStatsUid = trafficStatsUid;
    }

    void addHeader(String header, String value) {
        this.mHeadersList.add(new AbstractMap.SimpleImmutableEntry<String, String>(header, value));
    }
}

