/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.Network;
import android.net.connectivity.org.chromium.net.ExperimentalCronetEngine;
import android.net.connectivity.org.chromium.net.ExperimentalUrlRequest;
import android.net.http.UploadDataProvider;
import android.net.http.UploadDataProviderWrapper;
import android.net.http.UrlRequest;
import android.net.http.UrlRequestCallbackWrapper;
import android.net.http.UrlRequestWrapper;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class UrlRequestBuilderWrapper
extends UrlRequest.Builder {
    private boolean mCacheDisabled;
    private boolean mDirectExecutorAllowed;
    private Consumer<ExperimentalUrlRequest.Builder> mBuilderMutator = builder -> {};
    private Consumer<UrlRequestWrapper> mWrapperMutator = wrapper -> {};
    private UrlRequestCallbackWrapper mCallbackWrapper;
    private ExperimentalUrlRequest.Builder mBackend;
    private List<Map.Entry<String, String>> mHeaders;
    private boolean mHttpMethodSet;
    private final ExperimentalCronetEngine mCronetEngine;
    private final String mUrl;
    private final Executor mExecutor;
    private final UrlRequest.Callback mCallback;

    public UrlRequestBuilderWrapper(ExperimentalCronetEngine cronetEngine, String url, Executor executor, UrlRequest.Callback callback) {
        this.mCronetEngine = cronetEngine;
        this.mUrl = url;
        this.mExecutor = executor;
        this.mCallback = callback;
        this.mHeaders = new ArrayList<Map.Entry<String, String>>();
        this.mCallbackWrapper = new UrlRequestCallbackWrapper(this.mCallback);
        this.mBackend = this.mCronetEngine.newUrlRequestBuilder(this.mUrl, this.mCallbackWrapper, this.mExecutor);
    }

    private void maybeCreateBackendAndApplyMutator() {
        if (this.mBackend != null) {
            return;
        }
        this.mCallbackWrapper = new UrlRequestCallbackWrapper(this.mCallback);
        this.mBackend = this.mCronetEngine.newUrlRequestBuilder(this.mUrl, this.mCallbackWrapper, this.mExecutor);
        this.mBuilderMutator.accept(this.mBackend);
    }

    private void mutate(Consumer<ExperimentalUrlRequest.Builder> builderMutator, Consumer<UrlRequestWrapper> wrapperMutator) {
        this.maybeCreateBackendAndApplyMutator();
        this.mBuilderMutator = this.mBuilderMutator.andThen(builderMutator);
        builderMutator.accept(this.mBackend);
        if (wrapperMutator != null) {
            this.mWrapperMutator = this.mWrapperMutator.andThen(wrapperMutator);
        }
    }

    @Override
    public UrlRequest.Builder setHttpMethod(String method) {
        this.mutate(builder -> builder.setHttpMethod(method), wrapper -> wrapper.setHttpMethod(method));
        this.mHttpMethodSet = true;
        return this;
    }

    @Override
    public UrlRequest.Builder addHeader(String header, String value) {
        this.mutate(builder -> builder.addHeader(header, value), wrapper -> wrapper.addHeader(header, value));
        return this;
    }

    @Override
    public UrlRequest.Builder setCacheDisabled(boolean disableCache) {
        this.mCacheDisabled = disableCache;
        return this;
    }

    @Override
    public UrlRequest.Builder setPriority(int priority) {
        this.mutate(builder -> builder.setPriority(priority), wrapper -> wrapper.setPriority(priority));
        return this;
    }

    @Override
    @NonNull
    public UrlRequest.Builder setUploadDataProvider(@NonNull UploadDataProvider provider, @NonNull Executor executor) {
        this.mutate(builder -> builder.setUploadDataProvider(new UploadDataProviderWrapper(provider), executor), null);
        if (!this.mHttpMethodSet) {
            this.setHttpMethod("POST");
        }
        return this;
    }

    @Override
    @NonNull
    public UrlRequest.Builder setDirectExecutorAllowed(boolean allowDirectExecutor) {
        this.mDirectExecutorAllowed = allowDirectExecutor;
        return this;
    }

    @Override
    @NonNull
    public UrlRequest.Builder bindToNetwork(Network network) {
        this.mutate(builder -> builder.bindToNetwork(network != null ? network.getNetworkHandle() : -1L), null);
        return this;
    }

    @Override
    @NonNull
    public UrlRequest.Builder setTrafficStatsUid(int uid) {
        this.mutate(builder -> builder.setTrafficStatsUid(uid), wrapper -> wrapper.setTrafficStatsUid(uid));
        return this;
    }

    @Override
    @NonNull
    public UrlRequest.Builder setTrafficStatsTag(int tag) {
        this.mutate(builder -> builder.setTrafficStatsTag(tag), wrapper -> wrapper.setTrafficStatsTag(tag));
        return this;
    }

    @Override
    public UrlRequest build() {
        this.maybeCreateBackendAndApplyMutator();
        if (this.mCacheDisabled) {
            this.mBackend.disableCache();
        }
        if (this.mDirectExecutorAllowed) {
            this.mBackend.allowDirectExecutor();
        }
        this.mBuilderMutator.accept(this.mBackend);
        UrlRequestWrapper requestWrapper = new UrlRequestWrapper(this.mBackend.build(), this.mCacheDisabled, this.mDirectExecutorAllowed);
        this.mWrapperMutator.accept(requestWrapper);
        this.mCallbackWrapper.setOriginalRequestWrapper(requestWrapper);
        return requestWrapper;
    }
}

