/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.annotation.SuppressLint;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;

@SuppressLint(value={"UserHandleName"})
public class ConnectionMigrationOptions {
    private final int mEnableDefaultNetworkMigration;
    private final int mEnablePathDegradationMigration;
    @Nullable
    private final Boolean mAllowServerMigration;
    @Nullable
    private final Boolean mMigrateIdleConnections;
    @Nullable
    private final Duration mIdleMigrationPeriod;
    private final int mAllowNonDefaultNetworkUsage;
    @Nullable
    private final Duration mMaxTimeOnNonDefaultNetwork;
    @Nullable
    private final Integer mMaxWriteErrorNonDefaultNetworkMigrationsCount;
    @Nullable
    private final Integer mMaxPathDegradingNonDefaultMigrationsCount;
    public static final int MIGRATION_OPTION_UNSPECIFIED = 0;
    public static final int MIGRATION_OPTION_ENABLED = 1;
    public static final int MIGRATION_OPTION_DISABLED = 2;

    public int getDefaultNetworkMigration() {
        return this.mEnableDefaultNetworkMigration;
    }

    public int getPathDegradationMigration() {
        return this.mEnablePathDegradationMigration;
    }

    public int getAllowNonDefaultNetworkUsage() {
        return this.mAllowNonDefaultNetworkUsage;
    }

    ConnectionMigrationOptions(@NonNull Builder builder) {
        this.mEnableDefaultNetworkMigration = builder.mEnableDefaultNetworkMigration;
        this.mEnablePathDegradationMigration = builder.mEnablePathDegradationMigration;
        this.mAllowServerMigration = builder.mAllowServerMigration;
        this.mMigrateIdleConnections = builder.mMigrateIdleConnections;
        this.mIdleMigrationPeriod = builder.mIdleConnectionMigrationPeriod;
        this.mAllowNonDefaultNetworkUsage = builder.mAllowNonDefaultNetworkUsage;
        this.mMaxTimeOnNonDefaultNetwork = builder.mMaxTimeOnNonDefaultNetwork;
        this.mMaxWriteErrorNonDefaultNetworkMigrationsCount = builder.mMaxWriteErrorNonDefaultNetworkMigrationsCount;
        this.mMaxPathDegradingNonDefaultMigrationsCount = builder.mMaxPathDegradingNonDefaultMigrationsCount;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int mEnableDefaultNetworkMigration;
        private int mEnablePathDegradationMigration;
        @Nullable
        private Boolean mAllowServerMigration;
        @Nullable
        private Boolean mMigrateIdleConnections;
        @Nullable
        private Duration mIdleConnectionMigrationPeriod;
        private int mAllowNonDefaultNetworkUsage;
        @Nullable
        private Duration mMaxTimeOnNonDefaultNetwork;
        @Nullable
        private Integer mMaxWriteErrorNonDefaultNetworkMigrationsCount;
        @Nullable
        private Integer mMaxPathDegradingNonDefaultMigrationsCount;

        @NonNull
        public Builder setDefaultNetworkMigration(int state) {
            this.mEnableDefaultNetworkMigration = state;
            return this;
        }

        @NonNull
        public Builder setPathDegradationMigration(int state) {
            this.mEnablePathDegradationMigration = state;
            return this;
        }

        @Experimental
        @NonNull
        public Builder setAllowNonDefaultNetworkUsage(int state) {
            this.mAllowNonDefaultNetworkUsage = state;
            return this;
        }

        @NonNull
        public ConnectionMigrationOptions build() {
            return new ConnectionMigrationOptions(this);
        }
    }

    public static @interface Experimental {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MigrationOptionState {
    }
}

