/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.net.impl;

import android.net.connectivity.org.chromium.net.NetworkException;

public class NetworkExceptionImpl
extends NetworkException {
    protected final int mErrorCode;
    protected final int mCronetInternalErrorCode;

    public NetworkExceptionImpl(String message, int errorCode, int cronetInternalErrorCode) {
        super(message, null);
        assert (errorCode > 0 && errorCode < 12);
        assert (cronetInternalErrorCode < 0);
        this.mErrorCode = errorCode;
        this.mCronetInternalErrorCode = cronetInternalErrorCode;
    }

    @Override
    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public int getCronetInternalErrorCode() {
        return this.mCronetInternalErrorCode;
    }

    @Override
    public boolean immediatelyRetryable() {
        switch (this.mErrorCode) {
            default: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
        }
        return true;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder(super.getMessage());
        b.append(", ErrorCode=").append(this.mErrorCode);
        if (this.mCronetInternalErrorCode != 0) {
            b.append(", InternalErrorCode=").append(this.mCronetInternalErrorCode);
        }
        b.append(", Retryable=").append(this.immediatelyRetryable());
        return b.toString();
    }
}

