/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.base.TraceEvent;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.os.StrictMode;
import android.os._Original_Build;
import java.io.Closeable;

@NullMarked
public class StrictModeContext
implements Closeable {
    public static StrictModeContext allowAllVmPolicies() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowAllVmPolicies");){
            StrictMode.VmPolicy oldPolicy = StrictMode.getVmPolicy();
            StrictMode.setVmPolicy(StrictMode.VmPolicy.LAX);
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    public static StrictModeContext allowAllThreadPolicies() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowAllThreadPolicies");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy(StrictMode.ThreadPolicy.LAX);
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    public static StrictModeContext allowDiskWrites() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowDiskWrites");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    public static StrictModeContext allowDiskReads() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowDiskReads");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    public static StrictModeContext allowSlowCalls() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowSlowCalls");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder(oldPolicy).permitCustomSlowCalls().build());
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    public static StrictModeContext allowUnbufferedIo() {
        if (BuildConfig.DISABLE_STRICT_MODE_CONTEXT) {
            return new StrictModeContext();
        }
        try (TraceEvent e = TraceEvent.scoped("StrictModeContext.allowUnbufferedIo");){
            StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
            if (_Original_Build.VERSION.SDK_INT >= 26) {
                StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder(oldPolicy).permitUnbufferedIo().build());
            }
            Impl impl = new Impl(oldPolicy);
            return impl;
        }
    }

    @Override
    public void close() {
    }

    private static class Impl
    extends StrictModeContext {
        private final @Nullable StrictMode.ThreadPolicy mThreadPolicy;
        private final @Nullable StrictMode.VmPolicy mVmPolicy;

        private Impl(@Nullable StrictMode.ThreadPolicy threadPolicy, @Nullable StrictMode.VmPolicy vmPolicy) {
            this.mThreadPolicy = threadPolicy;
            this.mVmPolicy = vmPolicy;
        }

        private Impl(StrictMode.ThreadPolicy threadPolicy) {
            this(threadPolicy, null);
        }

        private Impl(StrictMode.VmPolicy vmPolicy) {
            this(null, vmPolicy);
        }

        @Override
        public void close() {
            if (this.mThreadPolicy != null) {
                StrictMode.setThreadPolicy(this.mThreadPolicy);
            }
            if (this.mVmPolicy != null) {
                StrictMode.setVmPolicy(this.mVmPolicy);
            }
            TraceEvent.finishAsync("StrictModeContext", this.hashCode());
        }
    }
}

