/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.build.NullUtil;
import android.net.connectivity.org.chromium.build.annotations.AlwaysInline;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.util.ArrayMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

@NullMarked
public class ServiceLoaderUtil {
    private static @Nullable Map<Class<?>, Object> sOverridesForTesting;

    private ServiceLoaderUtil() {
    }

    @AlwaysInline
    public static <T> @Nullable T maybeCreate(Class<T> clazz) {
        Object ret;
        if (sOverridesForTesting != null && (ret = sOverridesForTesting.get(clazz)) != null) {
            return clazz.cast(ret);
        }
        Iterator<T> it = ServiceLoader.load(clazz, clazz.getClassLoader()).iterator();
        if (it.hasNext()) {
            T ret2 = it.next();
            assert (!it.hasNext()) : String.format("Multiple implementations found for %s: %s and %s", clazz, ret2.getClass(), it.next().getClass());
            return ret2;
        }
        return null;
    }

    public static synchronized <T> void setInstanceForTesting(Class<T> clazz, T instance) {
        if (sOverridesForTesting == null) {
            sOverridesForTesting = new ArrayMap();
        }
        sOverridesForTesting.put(clazz, instance);
        ResettersForTesting.register(() -> NullUtil.assumeNonNull(sOverridesForTesting).remove(clazz));
    }
}

