/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.connectivity.org.chromium.base.JavaUtils;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.base.StrictModeContext;
import android.net.connectivity.org.chromium.build.BuildConfig;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.jni_zero.JNINamespace;
import android.os.Handler;
import android.os.Process;
import android.os._Original_Build;
import android.preference.PreferenceManager;

@JNINamespace(value="base::android")
@NullMarked
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static @Nullable Context sApplicationContext;
    public static final int RECEIVER_EXPORTED = 2;
    public static final int RECEIVER_NOT_EXPORTED = 4;

    public static Context getApplicationContext() {
        assert (sApplicationContext != null);
        return sApplicationContext;
    }

    public static void initApplicationContext(Context appContext) {
        assert (sApplicationContext == null || sApplicationContext == appContext || ((ContextWrapper)sApplicationContext).getBaseContext() == appContext);
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        try (StrictModeContext ignored = StrictModeContext.allowDiskWrites();){
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(ContextUtils.getApplicationContext());
            return sharedPreferences;
        }
    }

    public static SharedPreferences getAppSharedPreferences() {
        return Holder.sSharedPreferences;
    }

    public static void initApplicationContextForTests(Context appContext) {
        Context prevValue = sApplicationContext;
        ContextUtils.initJavaSideApplicationContext(appContext);
        SharedPreferences prevPrefs = Holder.sSharedPreferences;
        Holder.sSharedPreferences = ContextUtils.fetchAppSharedPreferences();
        ResettersForTesting.register(() -> {
            sApplicationContext = prevValue;
            Holder.sSharedPreferences = prevPrefs;
        });
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        assert (appContext != null);
        if (BuildConfig.ENABLE_ASSERTS && appContext instanceof Application) {
            appContext = new ContextWrapper(appContext);
        }
        sApplicationContext = appContext;
    }

    public static boolean isIsolatedProcess() {
        return Process.isIsolated();
    }

    public static boolean isSdkSandboxProcess() {
        if (_Original_Build.VERSION.SDK_INT >= 33) {
            return Process.isSdkSandbox();
        }
        return false;
    }

    public static String getProcessName() {
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        try {
            Class<?> activityThreadClazz = Class.forName("android.app.ActivityThread");
            return (String)activityThreadClazz.getMethod("currentProcessName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw JavaUtils.throwUnchecked(e);
        }
    }

    public static boolean isProcess64Bit() {
        return Process.is64Bit();
    }

    public static @Nullable Activity activityFromContext(@Nullable Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static @Nullable Intent registerProtectedBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, null, 0);
    }

    public static @Nullable Intent registerProtectedBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter, Handler scheduler) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, scheduler, 0);
    }

    public static @Nullable Intent registerExportedBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter, @Nullable String permission2) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, permission2, null, 2);
    }

    public static @Nullable Intent registerNonExportedBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, null, 4);
    }

    public static @Nullable Intent registerNonExportedBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter, @Nullable Handler scheduler) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, scheduler, 4);
    }

    private static @Nullable Intent registerBroadcastReceiver(Context context, @Nullable BroadcastReceiver receiver, IntentFilter filter, @Nullable String permission2, @Nullable Handler scheduler, int flags) {
        if (_Original_Build.VERSION.SDK_INT >= 26) {
            return context.registerReceiver(receiver, filter, permission2, scheduler, flags);
        }
        return context.registerReceiver(receiver, filter, permission2, scheduler);
    }

    private static class Holder {
        private static SharedPreferences sSharedPreferences = ContextUtils.fetchAppSharedPreferences();

        private Holder() {
        }
    }
}

