/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.org.chromium.base;

import android.net.connectivity.org.chromium.base.CommandLineJni;
import android.net.connectivity.org.chromium.base.Log;
import android.net.connectivity.org.chromium.base.ResettersForTesting;
import android.net.connectivity.org.chromium.build.NullUtil;
import android.net.connectivity.org.chromium.build.annotations.NullMarked;
import android.net.connectivity.org.chromium.build.annotations.Nullable;
import android.net.connectivity.org.chromium.build.annotations.RequiresNonNull;
import android.net.connectivity.org.jni_zero.JniType;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NullMarked
public class CommandLine {
    private static final String TAG = "CommandLine";
    private static final String SWITCH_PREFIX = "--";
    private static final String SWITCH_TERMINATOR = "--";
    private static final String SWITCH_VALUE_SEPARATOR = "=";
    private static final CommandLine sInstance = new CommandLine();
    private @Nullable Map<String, String> mSwitches;
    private @Nullable ArrayList<String> mArgs;
    private volatile int mArgsBegin;

    public static boolean isInitialized() {
        return CommandLine.sInstance.mArgsBegin != 0;
    }

    public static boolean hasSwitchedToNative() {
        assert (CommandLine.isInitialized());
        return CommandLine.sInstance.mArgs == null;
    }

    public static CommandLine getInstance() {
        assert (CommandLine.isInitialized());
        return sInstance;
    }

    public static void init(String @Nullable [] args) {
        sInstance.initInternal(args);
    }

    private static char @Nullable [] readFileAsUtf8(String fileName) {
        char[] cArray;
        File f = new File(fileName);
        FileReader reader = new FileReader(f);
        try {
            char[] buffer = new char[(int)f.length()];
            int charsRead = reader.read(buffer);
            cArray = Arrays.copyOfRange(buffer, 0, charsRead);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return cArray;
    }

    public static void initFromFile(String file) {
        char[] buffer = CommandLine.readFileAsUtf8(file);
        Object[] tokenized = buffer == null ? null : CommandLine.tokenizeQuotedArguments(buffer);
        CommandLine.init((String[])tokenized);
        if (tokenized != null) {
            Log.i(TAG, "COMMAND-LINE FLAGS: %s (from %s)", (Object)Arrays.toString(tokenized), (Object)file);
        }
    }

    public static void resetForTesting(boolean initialize) {
        CommandLine instance = sInstance;
        Map<String, String> origSwitches = instance.mSwitches;
        ArrayList<String> origArgs = instance.mArgs;
        int origArgsBegin = instance.mArgsBegin;
        instance.mSwitches = null;
        instance.mArgs = null;
        instance.mArgsBegin = 0;
        if (initialize) {
            instance.initInternal(null);
        }
        ResettersForTesting.register(() -> {
            instance.mSwitches = origSwitches;
            instance.mArgs = origArgs;
            instance.mArgsBegin = origArgsBegin;
        });
    }

    @VisibleForTesting
    static String[] tokenizeQuotedArguments(char[] buffer) {
        if (buffer.length > 98304) {
            throw new RuntimeException("Flags file too big: " + buffer.length);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = null;
        boolean noQuote = false;
        int singleQuote = 39;
        int doubleQuote = 34;
        char currentQuote = '\u0000';
        for (char c : buffer) {
            if (currentQuote == '\u0000' && (c == '\'' || c == '\"') || c == currentQuote) {
                if (arg != null && arg.length() > 0 && arg.charAt(arg.length() - 1) == '\\') {
                    arg.setCharAt(arg.length() - 1, c);
                    continue;
                }
                currentQuote = currentQuote == '\u0000' ? c : (char)'\u0000';
                continue;
            }
            if (currentQuote == '\u0000' && Character.isWhitespace(c)) {
                if (arg == null) continue;
                args.add(arg.toString());
                arg = null;
                continue;
            }
            if (arg == null) {
                arg = new StringBuilder();
            }
            arg.append(c);
        }
        if (arg != null) {
            if (currentQuote != '\u0000') {
                Log.w(TAG, "Unterminated quoted string: %s", (Object)arg);
            }
            args.add(arg.toString());
        }
        return args.toArray(new String[args.size()]);
    }

    public synchronized void switchToNativeImpl() {
        if (CommandLine.hasSwitchedToNative()) {
            return;
        }
        CommandLineJni.get().init((List<String>)NullUtil.assumeNonNull(this.mArgs));
        this.mArgs = null;
        this.mSwitches = null;
        Log.v(TAG, "Switched to native command-line", new Object[0]);
    }

    public static String[] getJavaSwitchesForTesting() {
        CommandLine commandLine = sInstance;
        if (commandLine == null) {
            return new String[0];
        }
        return NullUtil.assumeNonNull(commandLine.mArgs).toArray(new String[0]);
    }

    private synchronized void initInternal(String @Nullable [] args) {
        assert (!CommandLine.isInitialized() || !CommandLine.hasSwitchedToNative()) : "Cannot reinitialize after having switched to native.";
        this.mArgs = new ArrayList();
        this.mSwitches = new HashMap<String, String>();
        this.mArgsBegin = 1;
        if (args == null || args.length == 0 || args[0] == null) {
            this.mArgs.add("");
        } else {
            this.mArgs.add(args[0]);
            this.appendSwitchesInternalLocked(args, 1);
        }
    }

    public String getSwitchValue(String switchString, String defaultValue) {
        String value = this.getSwitchValue(switchString);
        return TextUtils.isEmpty(value) ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSwitch(String switchString) {
        Map<String, String> switches = this.mSwitches;
        if (switches == null) {
            return CommandLineJni.get().hasSwitch(switchString);
        }
        CommandLine commandLine = this;
        synchronized (commandLine) {
            return switches.containsKey(switchString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String getSwitchValue(String switchString) {
        String ret;
        Map<String, String> switches = this.mSwitches;
        if (switches == null) {
            ret = CommandLineJni.get().getSwitchValue(switchString);
        } else {
            CommandLine commandLine = this;
            synchronized (commandLine) {
                ret = switches.get(switchString);
            }
        }
        return TextUtils.isEmpty(ret) ? null : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSwitches() {
        Map<String, String> switches = this.mSwitches;
        if (switches == null) {
            return CommandLineJni.get().getSwitches();
        }
        CommandLine commandLine = this;
        synchronized (commandLine) {
            return new HashMap<String, String>(switches);
        }
    }

    public void appendSwitch(String switchString) {
        this.appendSwitchWithValue(switchString, null);
    }

    public synchronized void appendSwitchWithValue(String switchString, @Nullable String value) {
        if (value == null) {
            value = "";
        }
        if (this.mSwitches == null) {
            CommandLineJni.get().appendSwitchWithValue(switchString, value);
            return;
        }
        this.mSwitches.put(switchString, value);
        String combinedSwitchString = "--" + switchString;
        if (!value.isEmpty()) {
            combinedSwitchString = combinedSwitchString + SWITCH_VALUE_SEPARATOR + value;
        }
        NullUtil.assumeNonNull(this.mArgs);
        this.mArgs.add(this.mArgsBegin++, combinedSwitchString);
    }

    public synchronized void appendSwitchesAndArguments(String[] array2) {
        if (this.mArgs == null) {
            CommandLineJni.get().appendSwitchesAndArguments(array2);
        } else {
            this.appendSwitchesInternalLocked(array2, 0);
        }
    }

    @RequiresNonNull(value={"mArgs"})
    private void appendSwitchesInternalLocked(String[] array2, int skipCount) {
        boolean parseSwitches = true;
        for (String arg : array2) {
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            if (arg.equals("--")) {
                parseSwitches = false;
            }
            if (parseSwitches && arg.startsWith("--")) {
                String[] parts = arg.split(SWITCH_VALUE_SEPARATOR, 2);
                String value = parts.length > 1 ? parts[1] : null;
                this.appendSwitchWithValue(parts[0].substring("--".length()), value);
                continue;
            }
            this.mArgs.add(arg);
        }
    }

    public synchronized void removeSwitch(String switchString) {
        ArrayList<String> args = this.mArgs;
        if (args == null) {
            CommandLineJni.get().removeSwitch(switchString);
            return;
        }
        NullUtil.assumeNonNull(this.mSwitches);
        this.mSwitches.remove(switchString);
        String combinedSwitchString = "--" + switchString;
        for (int i = this.mArgsBegin - 1; i > 0; --i) {
            if (!args.get(i).equals(combinedSwitchString) && !args.get(i).startsWith(combinedSwitchString + SWITCH_VALUE_SEPARATOR)) continue;
            --this.mArgsBegin;
            args.remove(i);
        }
    }

    static interface Natives {
        public void init(@JniType(value="std::vector<std::string>") List<String> var1);

        public boolean hasSwitch(@JniType(value="std::string") String var1);

        public @JniType(value="std::string") String getSwitchValue(@JniType(value="std::string") String var1);

        public @JniType(value="base::CommandLine::SwitchMap") Map<String, String> getSwitches();

        public void appendSwitchWithValue(@JniType(value="std::string") String var1, @JniType(value="std::string") String var2);

        public void appendSwitchesAndArguments(@JniType(value="std::vector<std::string>") String[] var1);

        public void removeSwitch(@JniType(value="std::string") String var1);
    }
}

