/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.net.MacAddress;
import android.net.connectivity.com.android.net.module.util.HexDump;
import android.net.connectivity.com.android.net.module.util.InetAddressUtils;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Struct {
    private static ConcurrentHashMap<Class, FieldInfo[]> sFieldCache = new ConcurrentHashMap();

    private static void checkAnnotationType(Field annotation, Class fieldType) {
        switch (annotation.type().ordinal()) {
            case 0: {
                if (fieldType != Boolean.TYPE) break;
                return;
            }
            case 1: 
            case 7: {
                if (fieldType != Short.TYPE) break;
                return;
            }
            case 2: 
            case 8: 
            case 10: {
                if (fieldType != Integer.TYPE) break;
                return;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: {
                if (fieldType != Long.TYPE) break;
                return;
            }
            case 5: 
            case 13: {
                if (fieldType != BigInteger.class) break;
                return;
            }
            case 6: {
                if (fieldType != Byte.TYPE) break;
                return;
            }
            case 14: {
                if (fieldType != byte[].class) break;
                if (annotation.arraysize() <= 0) {
                    throw new IllegalArgumentException("Invalid ByteArray size: " + annotation.arraysize());
                }
                return;
            }
            case 15: {
                if (fieldType != MacAddress.class) break;
                return;
            }
            case 16: {
                if (fieldType != Inet4Address.class) break;
                return;
            }
            case 17: {
                if (fieldType != Inet6Address.class) break;
                return;
            }
            case 18: {
                if (fieldType != InetAddress.class) break;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown type" + (Object)((Object)annotation.type()));
            }
        }
        throw new IllegalArgumentException("Invalid primitive data type: " + fieldType + " for annotation type: " + (Object)((Object)annotation.type()));
    }

    private static int getFieldLength(Field annotation) {
        int length = 0;
        switch (annotation.type().ordinal()) {
            case 0: 
            case 1: 
            case 6: {
                length = 1;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                length = 2;
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                length = 4;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 12: 
            case 13: {
                length = 8;
                break;
            }
            case 14: {
                length = annotation.arraysize();
                break;
            }
            case 15: {
                length = 6;
                break;
            }
            case 16: {
                length = 4;
                break;
            }
            case 17: 
            case 18: {
                length = 16;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type" + (Object)((Object)annotation.type()));
            }
        }
        return length + annotation.padding();
    }

    private static boolean isStructSubclass(Class clazz) {
        return clazz != null && Struct.class.isAssignableFrom(clazz) && Struct.class != clazz;
    }

    private static int getAnnotationFieldCount(Class clazz) {
        int count = 0;
        for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Field.class)) continue;
            ++count;
        }
        return count;
    }

    private static boolean allFieldsFinal(FieldInfo[] fields, boolean immutable) {
        for (FieldInfo fi : fields) {
            if (Modifier.isFinal(fi.field.getModifiers()) == immutable) continue;
            return false;
        }
        return true;
    }

    private static boolean hasBothMutableAndImmutableFields(FieldInfo[] fields) {
        return !Struct.allFieldsFinal(fields, true) && !Struct.allFieldsFinal(fields, false);
    }

    private static boolean matchConstructor(Constructor cons, FieldInfo[] fields) {
        Class<?>[] paramTypes = cons.getParameterTypes();
        if (paramTypes.length != fields.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].equals(fields[i].field.getType())) continue;
            return false;
        }
        return true;
    }

    private static BigInteger readBigInteger(ByteBuffer buf, Type type) {
        byte[] input = new byte[8];
        boolean reverseBytes = type == Type.U64 && buf.order() == ByteOrder.LITTLE_ENDIAN;
        for (int i = 0; i < 8; ++i) {
            input[reverseBytes ? input.length - 1 - i : i] = buf.get();
        }
        return new BigInteger(1, input);
    }

    private static byte[] getLast8Bytes(byte[] input) {
        byte[] tmp = new byte[8];
        System.arraycopy(input, Math.max(0, input.length - 8), tmp, Math.max(0, 8 - input.length), Math.min(8, input.length));
        return tmp;
    }

    private static byte[] bigIntegerToU64Bytes(BigInteger bigInteger, ByteOrder order, Type type) {
        byte[] bigIntegerBytes = bigInteger.toByteArray();
        byte[] output = Struct.getLast8Bytes(bigIntegerBytes);
        if (type == Type.U64 && order == ByteOrder.LITTLE_ENDIAN) {
            for (int i = 0; i < 4; ++i) {
                byte tmp = output[i];
                output[i] = output[7 - i];
                output[7 - i] = tmp;
            }
        }
        return output;
    }

    private static Object getFieldValue(ByteBuffer buf, FieldInfo fieldInfo) throws BufferUnderflowException {
        Object value;
        Struct.checkAnnotationType(fieldInfo.annotation, fieldInfo.field.getType());
        switch (fieldInfo.annotation.type().ordinal()) {
            case 0: {
                value = buf.get() != 0;
                break;
            }
            case 1: {
                value = (short)(buf.get() & 0xFF);
                break;
            }
            case 2: {
                value = buf.getShort() & 0xFFFF;
                break;
            }
            case 3: {
                value = (long)buf.getInt() & 0xFFFFFFFFL;
                break;
            }
            case 5: {
                value = Struct.readBigInteger(buf, Type.U64);
                break;
            }
            case 6: {
                value = buf.get();
                break;
            }
            case 7: {
                value = buf.getShort();
                break;
            }
            case 8: {
                value = buf.getInt();
                break;
            }
            case 4: 
            case 9: {
                value = buf.getLong();
                break;
            }
            case 10: {
                if (buf.order() == ByteOrder.LITTLE_ENDIAN) {
                    value = Short.reverseBytes(buf.getShort()) & 0xFFFF;
                    break;
                }
                value = buf.getShort() & 0xFFFF;
                break;
            }
            case 11: {
                if (buf.order() == ByteOrder.LITTLE_ENDIAN) {
                    value = (long)Integer.reverseBytes(buf.getInt()) & 0xFFFFFFFFL;
                    break;
                }
                value = (long)buf.getInt() & 0xFFFFFFFFL;
                break;
            }
            case 12: {
                if (buf.order() == ByteOrder.LITTLE_ENDIAN) {
                    value = Long.reverseBytes(buf.getLong());
                    break;
                }
                value = buf.getLong();
                break;
            }
            case 13: {
                value = Struct.readBigInteger(buf, Type.UBE64);
                break;
            }
            case 14: {
                byte[] array2 = new byte[fieldInfo.annotation.arraysize()];
                buf.get(array2);
                value = array2;
                break;
            }
            case 15: {
                byte[] macAddress = new byte[6];
                buf.get(macAddress);
                value = MacAddress.fromBytes(macAddress);
                break;
            }
            case 16: 
            case 17: {
                boolean isIpv6 = fieldInfo.annotation.type() == Type.Ipv6Address;
                byte[] address = new byte[isIpv6 ? 16 : 4];
                buf.get(address);
                try {
                    if (isIpv6) {
                        value = Inet6Address.getByAddress(null, address, -1);
                        break;
                    }
                    value = InetAddress.getByAddress(address);
                    break;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("illegal length of IP address", e);
                }
            }
            case 18: {
                byte[] ipAddress = new byte[16];
                buf.get(ipAddress);
                try {
                    value = InetAddress.getByAddress(null, ipAddress);
                    break;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("illegal length of IP address", e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown type:" + (Object)((Object)fieldInfo.annotation.type()));
            }
        }
        if (fieldInfo.annotation.padding() > 0) {
            buf.position(buf.position() + fieldInfo.annotation.padding());
        }
        return value;
    }

    @Nullable
    private Object getFieldValue(@NonNull java.lang.reflect.Field field) {
        try {
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field: " + field, e);
        }
    }

    private static void putFieldValue(ByteBuffer output, FieldInfo fieldInfo, Object value) throws BufferUnderflowException {
        switch (fieldInfo.annotation.type().ordinal()) {
            case 0: {
                output.put((byte)(value != null && (Boolean)value != false ? 1 : 0));
                break;
            }
            case 1: {
                output.put((byte)((Short)value & 0xFF));
                break;
            }
            case 2: {
                output.putShort((short)((Integer)value & 0xFFFF));
                break;
            }
            case 3: {
                output.putInt((int)((Long)value & 0xFFFFFFFFL));
                break;
            }
            case 4: {
                output.putLong((Long)value);
                break;
            }
            case 5: {
                output.put(Struct.bigIntegerToU64Bytes((BigInteger)value, output.order(), Type.U64));
                break;
            }
            case 6: {
                output.put((Byte)value);
                break;
            }
            case 7: {
                output.putShort((Short)value);
                break;
            }
            case 8: {
                output.putInt((Integer)value);
                break;
            }
            case 9: {
                output.putLong((Long)value);
                break;
            }
            case 10: {
                if (output.order() == ByteOrder.LITTLE_ENDIAN) {
                    output.putShort(Short.reverseBytes((short)((Integer)value & 0xFFFF)));
                    break;
                }
                output.putShort((short)((Integer)value & 0xFFFF));
                break;
            }
            case 11: {
                if (output.order() == ByteOrder.LITTLE_ENDIAN) {
                    output.putInt(Integer.reverseBytes((int)((Long)value & 0xFFFFFFFFL)));
                    break;
                }
                output.putInt((int)((Long)value & 0xFFFFFFFFL));
                break;
            }
            case 12: {
                if (output.order() == ByteOrder.LITTLE_ENDIAN) {
                    output.putLong(Long.reverseBytes((Long)value));
                    break;
                }
                output.putLong((Long)value);
                break;
            }
            case 13: {
                output.put(Struct.bigIntegerToU64Bytes((BigInteger)value, output.order(), Type.UBE64));
                break;
            }
            case 14: {
                Struct.checkByteArraySize((byte[])value, fieldInfo);
                output.put((byte[])value);
                break;
            }
            case 15: {
                byte[] macAddress = ((MacAddress)value).toByteArray();
                output.put(macAddress);
                break;
            }
            case 16: 
            case 17: {
                byte[] address = ((InetAddress)value).getAddress();
                output.put(address);
                break;
            }
            case 18: {
                InetAddress inetAddress = (InetAddress)value;
                if (inetAddress instanceof Inet4Address) {
                    inetAddress = InetAddressUtils.v4MappedV6Address((Inet4Address)value);
                }
                output.put(inetAddress.getAddress());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type:" + (Object)((Object)fieldInfo.annotation.type()));
            }
        }
        for (int i = 0; i < fieldInfo.annotation.padding(); ++i) {
            output.put((byte)0);
        }
    }

    private static FieldInfo[] getClassFieldInfo(Class clazz) {
        if (!Struct.isStructSubclass(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a subclass of " + Struct.class.getName() + ", its superclass is " + clazz.getSuperclass().getName());
        }
        FieldInfo[] cachedAnnotationFields = sFieldCache.get(clazz);
        if (cachedAnnotationFields != null) {
            return cachedAnnotationFields;
        }
        FieldInfo[] annotationFields = new FieldInfo[Struct.getAnnotationFieldCount(clazz)];
        for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Computed.class) != null) continue;
            Field annotation = field.getAnnotation(Field.class);
            if (annotation == null) {
                throw new IllegalArgumentException("Field " + field.getName() + " is missing the " + Field.class.getSimpleName() + " annotation");
            }
            if (annotation.order() < 0 || annotation.order() >= annotationFields.length) {
                throw new IllegalArgumentException("Annotation order: " + annotation.order() + " is negative or non-consecutive");
            }
            if (annotationFields[annotation.order()] != null) {
                throw new IllegalArgumentException("Duplicated annotation order: " + annotation.order());
            }
            annotationFields[annotation.order()] = new FieldInfo(annotation, field);
        }
        sFieldCache.putIfAbsent(clazz, annotationFields);
        return annotationFields;
    }

    public static <T> T parse(Class<T> clazz, ByteBuffer buf) {
        try {
            Constructor<?>[] constructors;
            FieldInfo[] foundFields = Struct.getClassFieldInfo(clazz);
            if (Struct.hasBothMutableAndImmutableFields(foundFields)) {
                throw new IllegalArgumentException("Class has both final and non-final fields");
            }
            Constructor<?> constructor = null;
            Constructor<?> defaultConstructor = null;
            for (Constructor<?> cons : constructors = clazz.getDeclaredConstructors()) {
                if (Struct.matchConstructor(cons, foundFields)) {
                    constructor = cons;
                }
                if (cons.getParameterTypes().length != 0) continue;
                defaultConstructor = cons;
            }
            if (constructor == null && defaultConstructor == null) {
                throw new IllegalArgumentException("Fail to find available constructor");
            }
            if (constructor != null) {
                Object[] args = new Object[foundFields.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Struct.getFieldValue(buf, foundFields[i]);
                }
                return (T)constructor.newInstance(args);
            }
            Object instance = defaultConstructor.newInstance(new Object[0]);
            for (FieldInfo fi : foundFields) {
                fi.field.set(instance, Struct.getFieldValue(buf, fi));
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Fail to create a instance from constructor", e);
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Fail to read raw data from ByteBuffer", e);
        }
    }

    private static int getSizeInternal(FieldInfo[] fieldInfos) {
        int size = 0;
        for (FieldInfo fi : fieldInfos) {
            size += Struct.getFieldLength(fi.annotation);
        }
        return size;
    }

    private static void checkByteArraySize(@Nullable byte[] array2, @NonNull FieldInfo fieldInfo) {
        Objects.requireNonNull(array2, "null byte array for field " + fieldInfo.field.getName());
        int annotationArraySize = fieldInfo.annotation.arraysize();
        if (array2.length == annotationArraySize) {
            return;
        }
        throw new IllegalStateException("byte array actual length: " + array2.length + " doesn't match the declared array size: " + annotationArraySize);
    }

    private void writeToByteBufferInternal(ByteBuffer output, FieldInfo[] fieldInfos) {
        for (FieldInfo fi : fieldInfos) {
            Object value = this.getFieldValue(fi.field);
            try {
                Struct.putFieldValue(output, fi, value);
            }
            catch (BufferUnderflowException e) {
                throw new IllegalArgumentException("Fail to fill raw data to ByteBuffer", e);
            }
        }
    }

    public static <T extends Struct> int getSize(Class<T> clazz) {
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(clazz);
        return Struct.getSizeInternal(fieldInfos);
    }

    public void writeToByteBuffer(ByteBuffer output) {
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(this.getClass());
        this.writeToByteBufferInternal(output, fieldInfos);
    }

    public byte[] writeToBytes(ByteOrder order) {
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(this.getClass());
        byte[] output = new byte[Struct.getSizeInternal(fieldInfos)];
        ByteBuffer buffer = ByteBuffer.wrap(output);
        buffer.order(order);
        this.writeToByteBufferInternal(buffer, fieldInfos);
        return output;
    }

    public byte[] writeToBytes() {
        return this.writeToBytes(ByteOrder.nativeOrder());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(this.getClass());
        for (int i = 0; i < fieldInfos.length; ++i) {
            try {
                Object value = fieldInfos[i].field.get(this);
                Object otherValue = fieldInfos[i].field.get(obj);
                if (Objects.deepEquals(value, otherValue)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot access field: " + fieldInfos[i].field, e);
            }
        }
        return true;
    }

    public int hashCode() {
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(this.getClass());
        Object[] values = new Object[fieldInfos.length];
        for (int i = 0; i < fieldInfos.length; ++i) {
            Object value = this.getFieldValue(fieldInfos[i].field);
            values[i] = fieldInfos[i].field.getType() == byte[].class ? Integer.valueOf(Arrays.hashCode((byte[])value)) : value;
        }
        return Objects.hash(values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        FieldInfo[] fieldInfos = Struct.getClassFieldInfo(this.getClass());
        for (int i = 0; i < fieldInfos.length; ++i) {
            sb.append(fieldInfos[i].field.getName()).append(": ");
            Object value = this.getFieldValue(fieldInfos[i].field);
            if (value == null) {
                sb.append("null");
            } else if (fieldInfos[i].annotation.type() == Type.ByteArray) {
                sb.append("0x").append(HexDump.toHexString((byte[])value));
            } else if (fieldInfos[i].annotation.type() == Type.Ipv4Address || fieldInfos[i].annotation.type() == Type.Ipv6Address || fieldInfos[i].annotation.type() == Type.IpAddress) {
                sb.append(((InetAddress)value).getHostAddress());
            } else {
                sb.append(value.toString());
            }
            if (i == fieldInfos.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Field {
        public int order();

        public Type type();

        public int padding() default 0;

        public int arraysize() default 0;
    }

    public static enum Type {
        Bool,
        U8,
        U16,
        U32,
        U63,
        U64,
        S8,
        S16,
        S32,
        S64,
        UBE16,
        UBE32,
        UBE63,
        UBE64,
        ByteArray,
        EUI48,
        Ipv4Address,
        Ipv6Address,
        IpAddress;

    }

    private static class FieldInfo {
        @NonNull
        public final Field annotation;
        @NonNull
        public final java.lang.reflect.Field field;

        FieldInfo(Field annotation, java.lang.reflect.Field field) {
            this.annotation = annotation;
            this.field = field;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Computed {
    }

    public static class S64
    extends Struct {
        @Field(order=0, type=Type.S64)
        public final long val;

        public S64(long val) {
            this.val = val;
        }
    }

    public static class U32
    extends Struct {
        @Field(order=0, type=Type.U32)
        public final long val;

        public U32(long val) {
            this.val = val;
        }
    }

    public static class S32
    extends Struct {
        @Field(order=0, type=Type.S32)
        public final int val;

        public S32(int val) {
            this.val = val;
        }
    }

    public static class U8
    extends Struct {
        @Field(order=0, type=Type.U8)
        public final short val;

        public U8(short val) {
            this.val = val;
        }
    }

    public static class Bool
    extends Struct {
        @Field(order=0, type=Type.Bool)
        public final boolean val;

        public Bool(boolean val) {
            this.val = val;
        }
    }
}

