/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.com.android.net.module.util;

import android.annotation.NonNull;
import android.annotation.Nullable;

public class BitUtils {
    public static int[] unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val != 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>>= 1;
            ++bitPos;
        }
        return result;
    }

    public static long packBitList(int ... bits) {
        return BitUtils.packBits(bits);
    }

    public static long packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= 1L << b;
        }
        return packed;
    }

    public static void appendStringRepresentationOfBitMaskToStringBuilder(@NonNull StringBuilder sb, long bitMask, @NonNull NameOf nameFetcher, @NonNull String separator) {
        int bitPos = 0;
        boolean firstElementAdded = false;
        while (bitMask != 0L) {
            if ((bitMask & 1L) != 0L) {
                if (firstElementAdded) {
                    sb.append(separator);
                } else {
                    firstElementAdded = true;
                }
                sb.append(nameFetcher.nameOf(bitPos));
            }
            bitMask >>>= 1;
            ++bitPos;
        }
    }

    @Nullable
    public static String describeDifferences(long oldVal, long newVal, @NonNull NameOf nameFetcher) {
        long changed = oldVal ^ newVal;
        if (0L == changed) {
            return null;
        }
        long removed = oldVal & changed;
        long added = newVal & changed;
        StringBuilder sb = new StringBuilder();
        if (0L != removed) {
            sb.append("-");
            BitUtils.appendStringRepresentationOfBitMaskToStringBuilder(sb, removed, nameFetcher, "-");
        }
        if (0L != added) {
            sb.append("+");
            BitUtils.appendStringRepresentationOfBitMaskToStringBuilder(sb, added, nameFetcher, "+");
        }
        return sb.toString();
    }

    @FunctionalInterface
    public static interface NameOf {
        public String nameOf(int var1);
    }
}

