/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.vcn.persistablebundleutils;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.InetAddresses;
import android.net.connectivity.android.net.vcn.persistablebundleutils.CertUtils;
import android.net.connectivity.android.net.vcn.persistablebundleutils.EapSessionConfigUtils;
import android.net.connectivity.android.net.vcn.persistablebundleutils.IkeIdentificationUtils;
import android.net.connectivity.android.net.vcn.persistablebundleutils.IkeSaProposalUtils;
import android.net.connectivity.android.net.vcn.util.PersistableBundleUtils;
import android.net.eap.EapSessionConfig;
import android.net.ipsec.ike.IkeSaProposal;
import android.net.ipsec.ike.IkeSessionParams;
import android.os.PersistableBundle;
import android.system.OsConstants;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
public class IkeSessionParamsUtils {
    private static final String TAG = IkeSessionParamsUtils.class.getSimpleName();
    private static final String SERVER_HOST_NAME_KEY = "SERVER_HOST_NAME_KEY";
    private static final String SA_PROPOSALS_KEY = "SA_PROPOSALS_KEY";
    private static final String LOCAL_ID_KEY = "LOCAL_ID_KEY";
    private static final String REMOTE_ID_KEY = "REMOTE_ID_KEY";
    private static final String LOCAL_AUTH_KEY = "LOCAL_AUTH_KEY";
    private static final String REMOTE_AUTH_KEY = "REMOTE_AUTH_KEY";
    private static final String CONFIG_REQUESTS_KEY = "CONFIG_REQUESTS_KEY";
    private static final String RETRANS_TIMEOUTS_KEY = "RETRANS_TIMEOUTS_KEY";
    private static final String HARD_LIFETIME_SEC_KEY = "HARD_LIFETIME_SEC_KEY";
    private static final String SOFT_LIFETIME_SEC_KEY = "SOFT_LIFETIME_SEC_KEY";
    private static final String DPD_DELAY_SEC_KEY = "DPD_DELAY_SEC_KEY";
    private static final String NATT_KEEPALIVE_DELAY_SEC_KEY = "NATT_KEEPALIVE_DELAY_SEC_KEY";
    private static final String IKE_OPTIONS_KEY = "IKE_OPTIONS_KEY";
    private static final String IP_VERSION_KEY = "IP_VERSION_KEY";
    private static final String ENCAP_TYPE_KEY = "ENCAP_TYPE_KEY";
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final int IKE_OPTION_AUTOMATIC_ADDRESS_FAMILY_SELECTION = 6;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final int IKE_OPTION_AUTOMATIC_NATT_KEEPALIVES = 7;
    private static final Set<Integer> IKE_OPTIONS = new ArraySet<Integer>();

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static boolean isIkeOptionValid(int option) {
        try {
            new IkeSessionParams.Builder().addIkeOption(option);
            return true;
        }
        catch (IllegalArgumentException e) {
            Log.d(TAG, "Option not supported; discarding: " + option);
            return false;
        }
    }

    @NonNull
    public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams params) {
        if (params.getNetwork() != null || params.getIke3gppExtension() != null) {
            throw new IllegalStateException("Cannot convert a IkeSessionParams with a caller configured network or with 3GPP extension enabled");
        }
        PersistableBundle result = new PersistableBundle();
        result.putString(SERVER_HOST_NAME_KEY, params.getServerHostname());
        PersistableBundle saProposalBundle = PersistableBundleUtils.fromList(params.getSaProposals(), IkeSaProposalUtils::toPersistableBundle);
        result.putPersistableBundle(SA_PROPOSALS_KEY, saProposalBundle);
        result.putPersistableBundle(LOCAL_ID_KEY, IkeIdentificationUtils.toPersistableBundle(params.getLocalIdentification()));
        result.putPersistableBundle(REMOTE_ID_KEY, IkeIdentificationUtils.toPersistableBundle(params.getRemoteIdentification()));
        result.putPersistableBundle(LOCAL_AUTH_KEY, AuthConfigUtils.toPersistableBundle(params.getLocalAuthConfig()));
        result.putPersistableBundle(REMOTE_AUTH_KEY, AuthConfigUtils.toPersistableBundle(params.getRemoteAuthConfig()));
        ArrayList<ConfigRequest> reqList = new ArrayList<ConfigRequest>();
        for (IkeSessionParams.IkeConfigRequest req : params.getConfigurationRequests()) {
            reqList.add(new ConfigRequest(req));
        }
        PersistableBundle configReqListBundle = PersistableBundleUtils.fromList(reqList, ConfigRequest::toPersistableBundle);
        result.putPersistableBundle(CONFIG_REQUESTS_KEY, configReqListBundle);
        result.putIntArray(RETRANS_TIMEOUTS_KEY, params.getRetransmissionTimeoutsMillis());
        result.putInt(HARD_LIFETIME_SEC_KEY, params.getHardLifetimeSeconds());
        result.putInt(SOFT_LIFETIME_SEC_KEY, params.getSoftLifetimeSeconds());
        result.putInt(DPD_DELAY_SEC_KEY, params.getDpdDelaySeconds());
        result.putInt(NATT_KEEPALIVE_DELAY_SEC_KEY, params.getNattKeepAliveDelaySeconds());
        result.putInt(IP_VERSION_KEY, params.getIpVersion());
        result.putInt(ENCAP_TYPE_KEY, params.getEncapType());
        ArrayList<Integer> enabledIkeOptions = new ArrayList<Integer>();
        try {
            enabledIkeOptions.addAll(params.getIkeOptions());
        }
        catch (Exception e) {
            enabledIkeOptions.clear();
            for (int option : IKE_OPTIONS) {
                if (!IkeSessionParamsUtils.isIkeOptionValid(option) || !params.hasIkeOption(option)) continue;
                enabledIkeOptions.add(option);
            }
        }
        int[] optionArray = enabledIkeOptions.stream().mapToInt(i -> i).toArray();
        result.putIntArray(IKE_OPTIONS_KEY, optionArray);
        return result;
    }

    @NonNull
    public static IkeSessionParams fromPersistableBundle(@NonNull PersistableBundle in) {
        int[] optionArray;
        Objects.requireNonNull(in, "PersistableBundle is null");
        IkeSessionParams.Builder builder = new IkeSessionParams.Builder();
        builder.setServerHostname(in.getString(SERVER_HOST_NAME_KEY));
        PersistableBundle proposalBundle = in.getPersistableBundle(SA_PROPOSALS_KEY);
        Objects.requireNonNull(in, "SA Proposals was null");
        List<IkeSaProposal> saProposals = PersistableBundleUtils.toList(proposalBundle, IkeSaProposalUtils::fromPersistableBundle);
        for (IkeSaProposal proposal : saProposals) {
            builder.addSaProposal(proposal);
        }
        builder.setLocalIdentification(IkeIdentificationUtils.fromPersistableBundle(in.getPersistableBundle(LOCAL_ID_KEY)));
        builder.setRemoteIdentification(IkeIdentificationUtils.fromPersistableBundle(in.getPersistableBundle(REMOTE_ID_KEY)));
        AuthConfigUtils.setBuilderByReadingPersistableBundle(in.getPersistableBundle(LOCAL_AUTH_KEY), in.getPersistableBundle(REMOTE_AUTH_KEY), builder);
        builder.setRetransmissionTimeoutsMillis(in.getIntArray(RETRANS_TIMEOUTS_KEY));
        builder.setLifetimeSeconds(in.getInt(HARD_LIFETIME_SEC_KEY), in.getInt(SOFT_LIFETIME_SEC_KEY));
        builder.setDpdDelaySeconds(in.getInt(DPD_DELAY_SEC_KEY));
        builder.setNattKeepAliveDelaySeconds(in.getInt(NATT_KEEPALIVE_DELAY_SEC_KEY));
        builder.setIpVersion(in.getInt(IP_VERSION_KEY));
        builder.setEncapType(in.getInt(ENCAP_TYPE_KEY));
        PersistableBundle configReqListBundle = in.getPersistableBundle(CONFIG_REQUESTS_KEY);
        Objects.requireNonNull(configReqListBundle, "Config request list was null");
        List<ConfigRequest> reqList = PersistableBundleUtils.toList(configReqListBundle, ConfigRequest::new);
        block5: for (ConfigRequest req : reqList) {
            switch (req.type) {
                case 1: {
                    if (req.address == null) {
                        builder.addPcscfServerRequest(OsConstants.AF_INET);
                        continue block5;
                    }
                    builder.addPcscfServerRequest(req.address);
                    continue block5;
                }
                case 2: {
                    if (req.address == null) {
                        builder.addPcscfServerRequest(OsConstants.AF_INET6);
                        continue block5;
                    }
                    builder.addPcscfServerRequest(req.address);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unrecognized config request type: " + req.type);
        }
        Iterator<Object> iterator = IKE_OPTIONS.iterator();
        while (iterator.hasNext()) {
            int option = (Integer)iterator.next();
            if (!IkeSessionParamsUtils.isIkeOptionValid(option)) continue;
            builder.removeIkeOption(option);
        }
        for (int option : optionArray = in.getIntArray(IKE_OPTIONS_KEY)) {
            if (!IkeSessionParamsUtils.isIkeOptionValid(option)) continue;
            builder.addIkeOption(option);
        }
        return builder.build();
    }

    static {
        IKE_OPTIONS.add(0);
        IKE_OPTIONS.add(1);
        IKE_OPTIONS.add(2);
        IKE_OPTIONS.add(3);
        IKE_OPTIONS.add(4);
        IKE_OPTIONS.add(5);
        IKE_OPTIONS.add(6);
        IKE_OPTIONS.add(7);
        IKE_OPTIONS.add(8);
    }

    private static class AuthConfigUtils {
        private static final int IKE_AUTH_METHOD_PSK = 1;
        private static final int IKE_AUTH_METHOD_PUB_KEY_SIGNATURE = 2;
        private static final int IKE_AUTH_METHOD_EAP = 3;
        private static final String AUTH_METHOD_KEY = "AUTH_METHOD_KEY";

        private AuthConfigUtils() {
        }

        @NonNull
        public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams.IkeAuthConfig authConfig) {
            if (authConfig instanceof IkeSessionParams.IkeAuthPskConfig) {
                IkeSessionParams.IkeAuthPskConfig config = (IkeSessionParams.IkeAuthPskConfig)authConfig;
                return IkeAuthPskConfigUtils.toPersistableBundle(config, AuthConfigUtils.createPersistableBundle(1));
            }
            if (authConfig instanceof IkeSessionParams.IkeAuthDigitalSignLocalConfig) {
                IkeSessionParams.IkeAuthDigitalSignLocalConfig config = (IkeSessionParams.IkeAuthDigitalSignLocalConfig)authConfig;
                return IkeAuthDigitalSignConfigUtils.toPersistableBundle(config, AuthConfigUtils.createPersistableBundle(2));
            }
            if (authConfig instanceof IkeSessionParams.IkeAuthDigitalSignRemoteConfig) {
                IkeSessionParams.IkeAuthDigitalSignRemoteConfig config = (IkeSessionParams.IkeAuthDigitalSignRemoteConfig)authConfig;
                return IkeAuthDigitalSignConfigUtils.toPersistableBundle(config, AuthConfigUtils.createPersistableBundle(2));
            }
            if (authConfig instanceof IkeSessionParams.IkeAuthEapConfig) {
                IkeSessionParams.IkeAuthEapConfig config = (IkeSessionParams.IkeAuthEapConfig)authConfig;
                return IkeAuthEapConfigUtils.toPersistableBundle(config, AuthConfigUtils.createPersistableBundle(3));
            }
            throw new IllegalStateException("Invalid IkeAuthConfig subclass");
        }

        private static PersistableBundle createPersistableBundle(int type) {
            PersistableBundle result = new PersistableBundle();
            result.putInt(AUTH_METHOD_KEY, type);
            return result;
        }

        public static void setBuilderByReadingPersistableBundle(@NonNull PersistableBundle localAuthBundle, @NonNull PersistableBundle remoteAuthBundle, @NonNull IkeSessionParams.Builder builder) {
            Objects.requireNonNull(localAuthBundle, "localAuthBundle was null");
            Objects.requireNonNull(remoteAuthBundle, "remoteAuthBundle was null");
            int localMethodType = localAuthBundle.getInt(AUTH_METHOD_KEY);
            int remoteMethodType = remoteAuthBundle.getInt(AUTH_METHOD_KEY);
            switch (localMethodType) {
                case 1: {
                    if (remoteMethodType != 1) {
                        throw new IllegalArgumentException("Expect remote auth method to be PSK based, but was " + remoteMethodType);
                    }
                    IkeAuthPskConfigUtils.setBuilderByReadingPersistableBundle(localAuthBundle, remoteAuthBundle, builder);
                    return;
                }
                case 2: {
                    if (remoteMethodType != 2) {
                        throw new IllegalArgumentException("Expect remote auth method to be digital signature based, but was " + remoteMethodType);
                    }
                    IkeAuthDigitalSignConfigUtils.setBuilderByReadingPersistableBundle(localAuthBundle, remoteAuthBundle, builder);
                    return;
                }
                case 3: {
                    if (remoteMethodType != 2) {
                        throw new IllegalArgumentException("When using EAP for local authentication, expect remote auth method to be digital signature based, but was " + remoteMethodType);
                    }
                    IkeAuthEapConfigUtils.setBuilderByReadingPersistableBundle(localAuthBundle, remoteAuthBundle, builder);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid EAP method type " + localMethodType);
        }
    }

    private static class ConfigRequest {
        private static final int IPV4_P_CSCF_ADDRESS = 1;
        private static final int IPV6_P_CSCF_ADDRESS = 2;
        private static final String TYPE_KEY = "type";
        private static final String ADDRESS_KEY = "address";
        public final int type;
        @Nullable
        public final InetAddress address;

        ConfigRequest(IkeSessionParams.IkeConfigRequest config) {
            if (config instanceof IkeSessionParams.ConfigRequestIpv4PcscfServer) {
                this.type = 1;
                this.address = ((IkeSessionParams.ConfigRequestIpv4PcscfServer)config).getAddress();
            } else if (config instanceof IkeSessionParams.ConfigRequestIpv6PcscfServer) {
                this.type = 2;
                this.address = ((IkeSessionParams.ConfigRequestIpv6PcscfServer)config).getAddress();
            } else {
                throw new IllegalStateException("Unknown TunnelModeChildConfigRequest");
            }
        }

        ConfigRequest(PersistableBundle in) {
            Objects.requireNonNull(in, "PersistableBundle was null");
            this.type = in.getInt(TYPE_KEY);
            String addressStr = in.getString(ADDRESS_KEY);
            this.address = addressStr == null ? null : InetAddresses.parseNumericAddress(addressStr);
        }

        @NonNull
        public PersistableBundle toPersistableBundle() {
            PersistableBundle result = new PersistableBundle();
            result.putInt(TYPE_KEY, this.type);
            if (this.address != null) {
                result.putString(ADDRESS_KEY, this.address.getHostAddress());
            }
            return result;
        }
    }

    private static class IkeAuthEapConfigUtils {
        private static final String EAP_CONFIG_KEY = "EAP_CONFIG_KEY";

        private IkeAuthEapConfigUtils() {
        }

        @NonNull
        public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams.IkeAuthEapConfig config, @NonNull PersistableBundle result) {
            result.putPersistableBundle(EAP_CONFIG_KEY, EapSessionConfigUtils.toPersistableBundle(config.getEapConfig()));
            return result;
        }

        public static void setBuilderByReadingPersistableBundle(@NonNull PersistableBundle localAuthBundle, @NonNull PersistableBundle remoteAuthBundle, @NonNull IkeSessionParams.Builder builder) {
            PersistableBundle eapBundle = localAuthBundle.getPersistableBundle(EAP_CONFIG_KEY);
            Objects.requireNonNull(eapBundle, "EAP Config was null");
            EapSessionConfig eapConfig = EapSessionConfigUtils.fromPersistableBundle(eapBundle);
            PersistableBundle trustCertBundle = remoteAuthBundle.getPersistableBundle("TRUST_CERT_KEY");
            X509Certificate serverCaCert = null;
            if (trustCertBundle != null) {
                byte[] encodedCaCert = PersistableBundleUtils.toByteArray(trustCertBundle);
                serverCaCert = CertUtils.certificateFromByteArray(encodedCaCert);
            }
            builder.setAuthEap(serverCaCert, eapConfig);
        }
    }

    private static class IkeAuthDigitalSignConfigUtils {
        private static final String END_CERT_KEY = "END_CERT_KEY";
        private static final String INTERMEDIATE_CERTS_KEY = "INTERMEDIATE_CERTS_KEY";
        private static final String PRIVATE_KEY_KEY = "PRIVATE_KEY_KEY";
        private static final String TRUST_CERT_KEY = "TRUST_CERT_KEY";

        private IkeAuthDigitalSignConfigUtils() {
        }

        @NonNull
        public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams.IkeAuthDigitalSignLocalConfig config, @NonNull PersistableBundle result) {
            try {
                result.putPersistableBundle(END_CERT_KEY, PersistableBundleUtils.fromByteArray(config.getClientEndCertificate().getEncoded()));
                List<X509Certificate> certList = config.getIntermediateCertificates();
                ArrayList<byte[]> encodedCertList = new ArrayList<byte[]>(certList.size());
                for (X509Certificate cert : certList) {
                    encodedCertList.add(cert.getEncoded());
                }
                PersistableBundle certsBundle = PersistableBundleUtils.fromList(encodedCertList, PersistableBundleUtils::fromByteArray);
                result.putPersistableBundle(INTERMEDIATE_CERTS_KEY, certsBundle);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Fail to encode certificate");
            }
            result.putPersistableBundle(PRIVATE_KEY_KEY, PersistableBundleUtils.fromByteArray(config.getPrivateKey().getEncoded()));
            return result;
        }

        @NonNull
        public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams.IkeAuthDigitalSignRemoteConfig config, @NonNull PersistableBundle result) {
            try {
                X509Certificate caCert = config.getRemoteCaCert();
                if (caCert != null) {
                    result.putPersistableBundle(TRUST_CERT_KEY, PersistableBundleUtils.fromByteArray(caCert.getEncoded()));
                }
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Fail to encode the certificate");
            }
            return result;
        }

        public static void setBuilderByReadingPersistableBundle(@NonNull PersistableBundle localAuthBundle, @NonNull PersistableBundle remoteAuthBundle, @NonNull IkeSessionParams.Builder builder) {
            Objects.requireNonNull(localAuthBundle, "localAuthBundle was null");
            Objects.requireNonNull(remoteAuthBundle, "remoteAuthBundle was null");
            PersistableBundle endCertBundle = localAuthBundle.getPersistableBundle(END_CERT_KEY);
            Objects.requireNonNull(endCertBundle, "End cert was null");
            byte[] encodedCert = PersistableBundleUtils.toByteArray(endCertBundle);
            X509Certificate endCert = CertUtils.certificateFromByteArray(encodedCert);
            PersistableBundle certsBundle = localAuthBundle.getPersistableBundle(INTERMEDIATE_CERTS_KEY);
            Objects.requireNonNull(certsBundle, "Intermediate certs was null");
            List<byte[]> encodedCertList = PersistableBundleUtils.toList(certsBundle, PersistableBundleUtils::toByteArray);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(encodedCertList.size());
            for (byte[] encoded : encodedCertList) {
                certList.add(CertUtils.certificateFromByteArray(encoded));
            }
            PersistableBundle privateKeyBundle = localAuthBundle.getPersistableBundle(PRIVATE_KEY_KEY);
            Objects.requireNonNull(privateKeyBundle, "PrivateKey bundle was null");
            RSAPrivateKey privateKey = CertUtils.privateKeyFromByteArray(PersistableBundleUtils.toByteArray(privateKeyBundle));
            PersistableBundle trustCertBundle = remoteAuthBundle.getPersistableBundle(TRUST_CERT_KEY);
            X509Certificate caCert = null;
            if (trustCertBundle != null) {
                byte[] encodedCaCert = PersistableBundleUtils.toByteArray(trustCertBundle);
                caCert = CertUtils.certificateFromByteArray(encodedCaCert);
            }
            builder.setAuthDigitalSignature(caCert, endCert, certList, privateKey);
        }
    }

    private static class IkeAuthPskConfigUtils {
        private static final String PSK_KEY = "PSK_KEY";

        private IkeAuthPskConfigUtils() {
        }

        @NonNull
        public static PersistableBundle toPersistableBundle(@NonNull IkeSessionParams.IkeAuthPskConfig config, @NonNull PersistableBundle result) {
            result.putPersistableBundle(PSK_KEY, PersistableBundleUtils.fromByteArray(config.getPsk()));
            return result;
        }

        public static void setBuilderByReadingPersistableBundle(@NonNull PersistableBundle localAuthBundle, @NonNull PersistableBundle remoteAuthBundle, @NonNull IkeSessionParams.Builder builder) {
            Objects.requireNonNull(localAuthBundle, "localAuthBundle was null");
            Objects.requireNonNull(remoteAuthBundle, "remoteAuthBundle was null");
            PersistableBundle localPskBundle = localAuthBundle.getPersistableBundle(PSK_KEY);
            PersistableBundle remotePskBundle = remoteAuthBundle.getPersistableBundle(PSK_KEY);
            Objects.requireNonNull(localAuthBundle, "Local PSK was null");
            Objects.requireNonNull(remoteAuthBundle, "Remote PSK was null");
            byte[] localPsk = PersistableBundleUtils.toByteArray(localPskBundle);
            byte[] remotePsk = PersistableBundleUtils.toByteArray(remotePskBundle);
            if (!Arrays.equals(localPsk, remotePsk)) {
                throw new IllegalArgumentException("Local PSK and remote PSK are different");
            }
            builder.setAuthPsk(localPsk);
        }
    }
}

