/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.thread;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.thread.IStateCallback";

    public void onDeviceRoleChanged(int var1) throws RemoteException;

    public void onPartitionIdChanged(long var1) throws RemoteException;

    public void onThreadEnableStateChanged(int var1) throws RemoteException;

    public void onEphemeralKeyStateChanged(int var1, String var2, long var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStateCallback {
        static final int TRANSACTION_onDeviceRoleChanged = 1;
        static final int TRANSACTION_onPartitionIdChanged = 2;
        static final int TRANSACTION_onThreadEnableStateChanged = 3;
        static final int TRANSACTION_onEphemeralKeyStateChanged = 4;

        public Stub() {
            this.attachInterface(this, IStateCallback.DESCRIPTOR);
        }

        public static IStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IStateCallback) {
                return (IStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDeviceRoleChanged";
                }
                case 2: {
                    return "onPartitionIdChanged";
                }
                case 3: {
                    return "onThreadEnableStateChanged";
                }
                case 4: {
                    return "onEphemeralKeyStateChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDeviceRoleChanged(_arg0);
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onPartitionIdChanged(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onThreadEnableStateChanged(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onEphemeralKeyStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IStateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceRoleChanged(int deviceRole) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStateCallback.DESCRIPTOR);
                    _data.writeInt(deviceRole);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPartitionIdChanged(long partitionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStateCallback.DESCRIPTOR);
                    _data.writeLong(partitionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onThreadEnableStateChanged(int enabledState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStateCallback.DESCRIPTOR);
                    _data.writeInt(enabledState);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEphemeralKeyStateChanged(int ephemeralKeyState, String ephemeralKey, long lifetimeMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStateCallback.DESCRIPTOR);
                    _data.writeInt(ephemeralKeyState);
                    _data.writeString(ephemeralKey);
                    _data.writeLong(lifetimeMillis);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStateCallback {
        @Override
        public void onDeviceRoleChanged(int deviceRole) throws RemoteException {
        }

        @Override
        public void onPartitionIdChanged(long partitionId) throws RemoteException {
        }

        @Override
        public void onThreadEnableStateChanged(int enabledState) throws RemoteException {
        }

        @Override
        public void onEphemeralKeyStateChanged(int ephemeralKeyState, String ephemeralKey, long lifetimeMillis) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

