/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.thread;

import android.net.thread.ActiveOperationalDataset;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IActiveOperationalDatasetReceiver
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.thread.IActiveOperationalDatasetReceiver";

    public void onSuccess(ActiveOperationalDataset var1) throws RemoteException;

    public void onError(int var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IActiveOperationalDatasetReceiver {
        static final int TRANSACTION_onSuccess = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IActiveOperationalDatasetReceiver.DESCRIPTOR);
        }

        public static IActiveOperationalDatasetReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IActiveOperationalDatasetReceiver.DESCRIPTOR);
            if (iin != null && iin instanceof IActiveOperationalDatasetReceiver) {
                return (IActiveOperationalDatasetReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccess";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IActiveOperationalDatasetReceiver.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ActiveOperationalDataset _arg0 = data.readTypedObject(ActiveOperationalDataset.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSuccess(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IActiveOperationalDatasetReceiver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IActiveOperationalDatasetReceiver.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ActiveOperationalDataset dataset) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActiveOperationalDatasetReceiver.DESCRIPTOR);
                    _data.writeTypedObject(dataset, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode, String errorMessage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActiveOperationalDatasetReceiver.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMessage);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IActiveOperationalDatasetReceiver {
        @Override
        public void onSuccess(ActiveOperationalDataset dataset) throws RemoteException {
        }

        @Override
        public void onError(int errorCode, String errorMessage) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

