/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net.netstats;

import android.net.DataUsageRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUsageCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.connectivity.android.net.netstats.IUsageCallback";

    public void onThresholdReached(DataUsageRequest var1) throws RemoteException;

    public void onCallbackReleased(DataUsageRequest var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUsageCallback {
        static final int TRANSACTION_onThresholdReached = 1;
        static final int TRANSACTION_onCallbackReleased = 2;

        public Stub() {
            this.attachInterface(this, IUsageCallback.DESCRIPTOR);
        }

        public static IUsageCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUsageCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IUsageCallback) {
                return (IUsageCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onThresholdReached";
                }
                case 2: {
                    return "onCallbackReleased";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUsageCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    DataUsageRequest _arg0 = data.readTypedObject(DataUsageRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.onThresholdReached(_arg0);
                    break;
                }
                case 2: {
                    DataUsageRequest _arg0 = data.readTypedObject(DataUsageRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallbackReleased(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IUsageCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUsageCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onThresholdReached(DataUsageRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUsageCallback.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackReleased(DataUsageRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUsageCallback.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUsageCallback {
        @Override
        public void onThresholdReached(DataUsageRequest request) throws RemoteException {
        }

        @Override
        public void onCallbackReleased(DataUsageRequest request) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

