/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.IpPrefix;
import android.net.Network;
import android.net.QosFilter;
import android.net.QosSocketInfo;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.io.FileDescriptor;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class QosSocketFilter
extends QosFilter {
    private static final String TAG = QosSocketFilter.class.getSimpleName();
    @NonNull
    private final QosSocketInfo mQosSocketInfo;

    public QosSocketFilter(@NonNull QosSocketInfo qosSocketInfo) {
        Objects.requireNonNull(qosSocketInfo, "qosSocketInfo must be non-null");
        this.mQosSocketInfo = qosSocketInfo;
    }

    @NonNull
    public QosSocketInfo getQosSocketInfo() {
        return this.mQosSocketInfo;
    }

    @Override
    public int validate() {
        InetSocketAddress sa = this.getLocalAddressFromFileDescriptor();
        if (sa == null || sa.getAddress().isAnyLocalAddress() && sa.getPort() == 0) {
            return 2;
        }
        if (!sa.equals(this.mQosSocketInfo.getLocalSocketAddress())) {
            return 4;
        }
        if (this.mQosSocketInfo.getRemoteSocketAddress() != null) {
            InetSocketAddress da = this.getRemoteAddressFromFileDescriptor();
            if (da == null) {
                return 5;
            }
            if (!da.equals(this.mQosSocketInfo.getRemoteSocketAddress())) {
                return 6;
            }
        }
        return 0;
    }

    @Nullable
    private InetSocketAddress getLocalAddressFromFileDescriptor() {
        SocketAddress address;
        ParcelFileDescriptor parcelFileDescriptor = this.mQosSocketInfo.getParcelFileDescriptor();
        FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
        try {
            address = Os.getsockname(fd);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "getAddressFromFileDescriptor: getLocalAddress exception", e);
            return null;
        }
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    @Nullable
    private InetSocketAddress getRemoteAddressFromFileDescriptor() {
        SocketAddress address;
        ParcelFileDescriptor parcelFileDescriptor = this.mQosSocketInfo.getParcelFileDescriptor();
        FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
        try {
            address = Os.getpeername(fd);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "getAddressFromFileDescriptor: getRemoteAddress exception", e);
            return null;
        }
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    @Override
    @NonNull
    public Network getNetwork() {
        return this.mQosSocketInfo.getNetwork();
    }

    @Override
    public boolean matchesLocalAddress(@NonNull InetAddress address, int startPort, int endPort) {
        return this.matchesLocalPrefix(address instanceof Inet4Address ? new IpPrefix(address, 32) : new IpPrefix(address, 128), startPort, endPort);
    }

    @Override
    public boolean matchesRemoteAddress(@NonNull InetAddress address, int startPort, int endPort) {
        return this.matchesRemotePrefix(address instanceof Inet4Address ? new IpPrefix(address, 32) : new IpPrefix(address, 128), startPort, endPort);
    }

    @Override
    public boolean matchesLocalPrefix(@NonNull IpPrefix ipPrefix, int startPort, int endPort) {
        if (this.mQosSocketInfo.getLocalSocketAddress() == null) {
            return false;
        }
        return QosSocketFilter.matchesAddress(this.mQosSocketInfo.getLocalSocketAddress(), ipPrefix, startPort, endPort);
    }

    @Override
    public boolean matchesRemotePrefix(@NonNull IpPrefix ipPrefix, int startPort, int endPort) {
        if (this.mQosSocketInfo.getRemoteSocketAddress() == null) {
            return false;
        }
        return QosSocketFilter.matchesAddress(this.mQosSocketInfo.getRemoteSocketAddress(), ipPrefix, startPort, endPort);
    }

    @Override
    public boolean matchesProtocol(int protocol) {
        return this.mQosSocketInfo.getSocketType() == OsConstants.SOCK_STREAM && protocol == OsConstants.IPPROTO_TCP || this.mQosSocketInfo.getSocketType() == OsConstants.SOCK_DGRAM && protocol == OsConstants.IPPROTO_UDP;
    }

    @VisibleForTesting
    public static boolean matchesAddress(@NonNull InetSocketAddress filterSocketAddress, @NonNull IpPrefix ipPrefix, int startPort, int endPort) {
        return startPort <= filterSocketAddress.getPort() && endPort >= filterSocketAddress.getPort() && (ipPrefix.getAddress().isAnyLocalAddress() || ipPrefix.contains(filterSocketAddress.getAddress()));
    }
}

