/*
 * Decompiled with CFR 0.152.
 */
package android.net.connectivity.android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class MulticastRoutingConfig
implements Parcelable {
    private static final String TAG = MulticastRoutingConfig.class.getSimpleName();
    public static final int FORWARD_NONE = 0;
    public static final int FORWARD_SELECTED = 1;
    public static final int FORWARD_WITH_MIN_SCOPE = 2;
    public static final int MULTICAST_SCOPE_NONE = -1;
    public static final MulticastRoutingConfig CONFIG_FORWARD_NONE = new MulticastRoutingConfig(0, -1, null);
    private final int mForwardingMode;
    private final int mMinScope;
    @NonNull
    private final Set<Inet6Address> mListeningAddresses;
    @NonNull
    public static final Parcelable.Creator<MulticastRoutingConfig> CREATOR = new Parcelable.Creator<MulticastRoutingConfig>(){

        @Override
        public MulticastRoutingConfig createFromParcel(@NonNull Parcel in) {
            return new MulticastRoutingConfig(in);
        }

        public MulticastRoutingConfig[] newArray(int size) {
            return new MulticastRoutingConfig[size];
        }
    };

    private MulticastRoutingConfig(int mode, int scope, @Nullable Set<Inet6Address> addresses) {
        this.mForwardingMode = mode;
        this.mMinScope = scope;
        this.mListeningAddresses = null != addresses ? Collections.unmodifiableSet(new ArraySet<Inet6Address>(addresses)) : Collections.emptySet();
    }

    public int getForwardingMode() {
        return this.mForwardingMode;
    }

    public int getMinimumScope() {
        return this.mMinScope;
    }

    @NonNull
    public Set<Inet6Address> getListeningAddresses() {
        return this.mListeningAddresses;
    }

    private MulticastRoutingConfig(Parcel in) {
        this.mForwardingMode = in.readInt();
        this.mMinScope = in.readInt();
        int count = in.readInt();
        ArraySet<Inet6Address> listeningAddresses = new ArraySet<Inet6Address>(count);
        byte[] buffer = new byte[16];
        for (int i = 0; i < count; ++i) {
            in.readByteArray(buffer);
            try {
                listeningAddresses.add((Inet6Address)Inet6Address.getByAddress(buffer));
                continue;
            }
            catch (UnknownHostException e) {
                Log.wtf(TAG, "Can't read inet6address : " + Arrays.toString(buffer));
            }
        }
        this.mListeningAddresses = Collections.unmodifiableSet(listeningAddresses);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mForwardingMode);
        dest.writeInt(this.mMinScope);
        dest.writeInt(this.mListeningAddresses.size());
        for (Inet6Address addr : this.mListeningAddresses) {
            dest.writeByteArray(addr.getAddress());
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static String forwardingModeToString(int forwardingMode) {
        switch (forwardingMode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SELECTED";
            }
            case 2: {
                return "WITH_MIN_SCOPE";
            }
        }
        return "UNKNOWN";
    }

    private static String modeToString(int mode) {
        switch (mode) {
            case 0: {
                return "FORWARD_NONE";
            }
            case 1: {
                return "FORWARD_SELECTED";
            }
            case 2: {
                return "FORWARD_WITH_MIN_SCOPE";
            }
        }
        return "unknown multicast routing mode " + mode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MulticastRoutingConfig)) {
            return false;
        }
        MulticastRoutingConfig otherConfig = (MulticastRoutingConfig)other;
        return this.mForwardingMode == otherConfig.mForwardingMode && this.mMinScope == otherConfig.mMinScope && this.mListeningAddresses.equals(otherConfig.mListeningAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.mForwardingMode, this.mMinScope, this.mListeningAddresses);
    }

    public String toString() {
        StringJoiner resultJoiner = new StringJoiner(" ", "{", "}");
        resultJoiner.add("ForwardingMode:");
        resultJoiner.add(MulticastRoutingConfig.modeToString(this.mForwardingMode));
        if (this.mForwardingMode == 2) {
            resultJoiner.add("MinScope:");
            resultJoiner.add(Integer.toString(this.mMinScope));
        }
        if (this.mForwardingMode == 1 && !this.mListeningAddresses.isEmpty()) {
            resultJoiner.add("ListeningAddresses: [");
            resultJoiner.add(TextUtils.join((CharSequence)",", this.mListeningAddresses));
            resultJoiner.add("]");
        }
        return ((Object)resultJoiner).toString();
    }

    public static class Builder {
        private final int mForwardingMode;
        private int mMinScope;
        private final ArraySet<Inet6Address> mListeningAddresses;

        public Builder(int mode) {
            if (0 != mode && 1 != mode) {
                if (2 == mode) {
                    throw new IllegalArgumentException("FORWARD_WITH_MIN_SCOPE requires passing the scope as a second argument");
                }
                throw new IllegalArgumentException("Unknown forwarding mode : " + mode);
            }
            this.mForwardingMode = mode;
            this.mMinScope = -1;
            this.mListeningAddresses = new ArraySet();
        }

        public Builder(int mode, int scope) {
            if (2 != mode) {
                throw new IllegalArgumentException("Forwarding with a min scope must use forward mode FORWARD_WITH_MIN_SCOPE");
            }
            this.mForwardingMode = mode;
            this.mMinScope = scope;
            this.mListeningAddresses = new ArraySet();
        }

        @NonNull
        public Builder setMinimumScope(int scope) {
            if (2 != this.mForwardingMode) {
                throw new IllegalArgumentException("Can't set the scope on a builder in mode " + MulticastRoutingConfig.modeToString(this.mForwardingMode));
            }
            this.mMinScope = scope;
            return this;
        }

        @NonNull
        public Builder addListeningAddress(@NonNull Inet6Address address) {
            if (1 != this.mForwardingMode) {
                throw new IllegalArgumentException("Can't add an address on a builder in mode " + MulticastRoutingConfig.modeToString(this.mForwardingMode));
            }
            this.mListeningAddresses.add(address);
            return this;
        }

        @NonNull
        public Builder clearListeningAddress(@NonNull Inet6Address address) {
            if (1 != this.mForwardingMode) {
                throw new IllegalArgumentException("Can't remove an address on a builder in mode " + MulticastRoutingConfig.modeToString(this.mForwardingMode));
            }
            this.mListeningAddresses.remove(address);
            return this;
        }

        @NonNull
        public MulticastRoutingConfig build() {
            return new MulticastRoutingConfig(this.mForwardingMode, this.mMinScope, this.mListeningAddresses);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MulticastForwardingMode {
    }
}

