/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.LinkAddress;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

@SystemApi
public class TetheredClient
implements Parcelable {
    @NonNull
    private final MacAddress mMacAddress;
    @NonNull
    private final List<AddressInfo> mAddresses;
    private final int mTetheringType;
    @NonNull
    public static final Parcelable.Creator<TetheredClient> CREATOR = new Parcelable.Creator<TetheredClient>(){

        @Override
        @NonNull
        public TetheredClient createFromParcel(@NonNull Parcel in) {
            return new TetheredClient(in);
        }

        @NonNull
        public TetheredClient[] newArray(int size) {
            return new TetheredClient[size];
        }
    };

    public TetheredClient(@NonNull MacAddress macAddress, @NonNull Collection<AddressInfo> addresses, int tetheringType) {
        this.mMacAddress = macAddress;
        this.mAddresses = new ArrayList<AddressInfo>(addresses);
        this.mTetheringType = tetheringType;
    }

    private TetheredClient(@NonNull Parcel in) {
        this((MacAddress)in.readParcelable(null), in.createTypedArrayList(AddressInfo.CREATOR), in.readInt());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mMacAddress, flags);
        dest.writeTypedList(this.mAddresses);
        dest.writeInt(this.mTetheringType);
    }

    @NonNull
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    @NonNull
    public List<AddressInfo> getAddresses() {
        return new ArrayList<AddressInfo>(this.mAddresses);
    }

    public int getTetheringType() {
        return this.mTetheringType;
    }

    public TetheredClient addAddresses(@NonNull TetheredClient other) {
        LinkedHashSet<AddressInfo> newAddresses = new LinkedHashSet<AddressInfo>(this.mAddresses.size() + other.mAddresses.size());
        newAddresses.addAll(this.mAddresses);
        newAddresses.addAll(other.mAddresses);
        return new TetheredClient(this.mMacAddress, newAddresses, this.mTetheringType);
    }

    public int hashCode() {
        return Objects.hash(this.mMacAddress, this.mAddresses, this.mTetheringType);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TetheredClient)) {
            return false;
        }
        TetheredClient other = (TetheredClient)obj;
        return ((Object)this.mMacAddress).equals(other.mMacAddress) && this.mAddresses.equals(other.mAddresses) && this.mTetheringType == other.mTetheringType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return "TetheredClient {hwAddr " + this.mMacAddress + ", addresses " + this.mAddresses + ", tetheringType " + this.mTetheringType + "}";
    }

    public static class AddressInfo
    implements Parcelable {
        @NonNull
        private final LinkAddress mAddress;
        @Nullable
        private final String mHostname;
        @NonNull
        public static final Parcelable.Creator<AddressInfo> CREATOR = new Parcelable.Creator<AddressInfo>(){

            @Override
            @NonNull
            public AddressInfo createFromParcel(@NonNull Parcel in) {
                return new AddressInfo(in);
            }

            @NonNull
            public AddressInfo[] newArray(int size) {
                return new AddressInfo[size];
            }
        };

        public AddressInfo(@NonNull LinkAddress address, @Nullable String hostname) {
            this.mAddress = address;
            this.mHostname = hostname;
        }

        private AddressInfo(Parcel in) {
            this((LinkAddress)in.readParcelable(null), in.readString());
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable(this.mAddress, flags);
            dest.writeString(this.mHostname);
        }

        @NonNull
        public LinkAddress getAddress() {
            return this.mAddress;
        }

        @Nullable
        public String getHostname() {
            return this.mHostname;
        }

        public long getExpirationTime() {
            return this.mAddress.getExpirationTime();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.mAddress, this.mHostname);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof AddressInfo)) {
                return false;
            }
            AddressInfo other = (AddressInfo)obj;
            return ((Object)other.mAddress).equals(this.mAddress) && Objects.equals(this.mHostname, other.mHostname);
        }

        @NonNull
        public String toString() {
            return "AddressInfo {" + this.mAddress + (this.mHostname != null ? ", hostname " + this.mHostname : "") + "}";
        }
    }
}

