/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.MacAddress;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import java.net.NetworkInterface;
import java.net.SocketException;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class TestNetworkInterface
implements Parcelable {
    private static final String TAG = "TestNetworkInterface";
    @NonNull
    private final ParcelFileDescriptor mFileDescriptor;
    @NonNull
    private final String mInterfaceName;
    @Nullable
    private final MacAddress mMacAddress;
    private final int mMtu;
    @NonNull
    public static final Parcelable.Creator<TestNetworkInterface> CREATOR = new Parcelable.Creator<TestNetworkInterface>(){

        @Override
        public TestNetworkInterface createFromParcel(Parcel in) {
            return new TestNetworkInterface(in);
        }

        public TestNetworkInterface[] newArray(int size) {
            return new TestNetworkInterface[size];
        }
    };

    @Override
    public int describeContents() {
        return this.mFileDescriptor != null ? 1 : 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeParcelable(this.mFileDescriptor, flags);
        out.writeString(this.mInterfaceName);
        out.writeParcelable(this.mMacAddress, flags);
        out.writeInt(this.mMtu);
    }

    public TestNetworkInterface(@NonNull ParcelFileDescriptor pfd, @NonNull String intf) {
        this.mFileDescriptor = pfd;
        this.mInterfaceName = intf;
        MacAddress macAddress = null;
        int mtu = 1500;
        try {
            NetworkInterface nif = NetworkInterface.getByName(this.mInterfaceName);
            byte[] hardwareAddress = nif.getHardwareAddress();
            if (hardwareAddress != null) {
                macAddress = MacAddress.fromBytes(nif.getHardwareAddress());
            }
            mtu = nif.getMTU();
        }
        catch (SocketException e) {
            Log.e(TAG, "Failed to fetch MacAddress or MTU size from NetworkInterface", e);
        }
        this.mMacAddress = macAddress;
        this.mMtu = mtu;
    }

    private TestNetworkInterface(@NonNull Parcel in) {
        this.mFileDescriptor = (ParcelFileDescriptor)in.readParcelable(ParcelFileDescriptor.class.getClassLoader());
        this.mInterfaceName = in.readString();
        this.mMacAddress = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
        this.mMtu = in.readInt();
    }

    @NonNull
    public ParcelFileDescriptor getFileDescriptor() {
        return this.mFileDescriptor;
    }

    @NonNull
    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    @Nullable
    public MacAddress getMacAddress() {
        return this.mMacAddress;
    }

    public int getMtu() {
        return this.mMtu;
    }
}

