/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;

public class TelephonyNetworkSpecifier
extends NetworkSpecifier
implements Parcelable {
    private final int mSubId;
    @NonNull
    public static final Parcelable.Creator<TelephonyNetworkSpecifier> CREATOR = new Parcelable.Creator<TelephonyNetworkSpecifier>(){

        @Override
        public TelephonyNetworkSpecifier createFromParcel(Parcel in) {
            int subId = in.readInt();
            return new TelephonyNetworkSpecifier(subId);
        }

        public TelephonyNetworkSpecifier[] newArray(int size) {
            return new TelephonyNetworkSpecifier[size];
        }
    };

    public int getSubscriptionId() {
        return this.mSubId;
    }

    public TelephonyNetworkSpecifier(int subId) {
        this.mSubId = subId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSubId);
    }

    public int hashCode() {
        return this.mSubId;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TelephonyNetworkSpecifier)) {
            return false;
        }
        TelephonyNetworkSpecifier lhs = (TelephonyNetworkSpecifier)obj;
        return this.mSubId == lhs.mSubId;
    }

    public String toString() {
        return "TelephonyNetworkSpecifier [" + "mSubId = " + this.mSubId + "]";
    }

    @Override
    public boolean canBeSatisfiedBy(NetworkSpecifier other) {
        return this.equals(other) || other instanceof MatchAllNetworkSpecifier;
    }

    public static class Builder {
        private static final int SENTINEL_SUB_ID = Integer.MIN_VALUE;
        private int mSubId = Integer.MIN_VALUE;

        @NonNull
        public Builder setSubscriptionId(int subId) {
            this.mSubId = subId;
            return this;
        }

        @NonNull
        public TelephonyNetworkSpecifier build() {
            if (this.mSubId == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Subscription Id is not provided.");
            }
            return new TelephonyNetworkSpecifier(this.mSubId);
        }
    }
}

