/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkSpecifier;
import android.net.TelephonyNetworkSpecifier;
import android.net.connectivity.com.android.net.module.util.NetworkIdentityUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NetworkStateSnapshot
implements Parcelable {
    @NonNull
    private final Network mNetwork;
    @NonNull
    private final NetworkCapabilities mNetworkCapabilities;
    @NonNull
    private final LinkProperties mLinkProperties;
    @Nullable
    private final String mSubscriberId;
    private final int mLegacyType;
    @NonNull
    public static final Parcelable.Creator<NetworkStateSnapshot> CREATOR = new Parcelable.Creator<NetworkStateSnapshot>(){

        @Override
        @NonNull
        public NetworkStateSnapshot createFromParcel(@NonNull Parcel in) {
            return new NetworkStateSnapshot(in);
        }

        @NonNull
        public NetworkStateSnapshot[] newArray(int size) {
            return new NetworkStateSnapshot[size];
        }
    };

    public NetworkStateSnapshot(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities, @NonNull LinkProperties linkProperties, @Nullable String subscriberId, int legacyType) {
        this.mNetwork = Objects.requireNonNull(network);
        this.mNetworkCapabilities = Objects.requireNonNull(networkCapabilities);
        this.mLinkProperties = Objects.requireNonNull(linkProperties);
        this.mSubscriberId = subscriberId;
        this.mLegacyType = legacyType;
    }

    public NetworkStateSnapshot(@NonNull Parcel in) {
        this.mNetwork = in.readParcelable(null, Network.class);
        this.mNetworkCapabilities = in.readParcelable(null, NetworkCapabilities.class);
        this.mLinkProperties = in.readParcelable(null, LinkProperties.class);
        this.mSubscriberId = in.readString();
        this.mLegacyType = in.readInt();
    }

    @NonNull
    public Network getNetwork() {
        return this.mNetwork;
    }

    @NonNull
    public NetworkCapabilities getNetworkCapabilities() {
        return this.mNetworkCapabilities;
    }

    @NonNull
    public LinkProperties getLinkProperties() {
        return this.mLinkProperties;
    }

    @Deprecated
    @Nullable
    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public int getSubId() {
        NetworkSpecifier spec;
        if (this.mNetworkCapabilities.hasTransport(0) && (spec = this.mNetworkCapabilities.getNetworkSpecifier()) instanceof TelephonyNetworkSpecifier) {
            return ((TelephonyNetworkSpecifier)spec).getSubscriptionId();
        }
        return -1;
    }

    public int getLegacyType() {
        return this.mLegacyType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeParcelable(this.mNetwork, flags);
        out.writeParcelable(this.mNetworkCapabilities, flags);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeString(this.mSubscriberId);
        out.writeInt(this.mLegacyType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkStateSnapshot)) {
            return false;
        }
        NetworkStateSnapshot that = (NetworkStateSnapshot)o;
        return this.mLegacyType == that.mLegacyType && Objects.equals(this.mNetwork, that.mNetwork) && Objects.equals(this.mNetworkCapabilities, that.mNetworkCapabilities) && Objects.equals(this.mLinkProperties, that.mLinkProperties) && Objects.equals(this.mSubscriberId, that.mSubscriberId);
    }

    public int hashCode() {
        return Objects.hash(this.mNetwork, this.mNetworkCapabilities, this.mLinkProperties, this.mSubscriberId, this.mLegacyType);
    }

    public String toString() {
        return "NetworkStateSnapshot{network=" + this.mNetwork + ", networkCapabilities=" + this.mNetworkCapabilities + ", linkProperties=" + this.mLinkProperties + ", subscriberId='" + NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId) + '\'' + ", legacyType=" + this.mLegacyType + '}';
    }
}

