/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IPacProxyInstalledListener;
import android.net.ProxyInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IPacProxyManager
extends IInterface {
    public static final String DESCRIPTOR = "android.net.IPacProxyManager";

    public void addListener(IPacProxyInstalledListener var1) throws RemoteException;

    public void removeListener(IPacProxyInstalledListener var1) throws RemoteException;

    public void setCurrentProxyScriptUrl(ProxyInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPacProxyManager {
        static final int TRANSACTION_addListener = 1;
        static final int TRANSACTION_removeListener = 2;
        static final int TRANSACTION_setCurrentProxyScriptUrl = 3;

        public Stub() {
            this.attachInterface(this, IPacProxyManager.DESCRIPTOR);
        }

        public static IPacProxyManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPacProxyManager.DESCRIPTOR);
            if (iin != null && iin instanceof IPacProxyManager) {
                return (IPacProxyManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addListener";
                }
                case 2: {
                    return "removeListener";
                }
                case 3: {
                    return "setCurrentProxyScriptUrl";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPacProxyManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IPacProxyInstalledListener _arg0 = IPacProxyInstalledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IPacProxyInstalledListener _arg0 = IPacProxyInstalledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ProxyInfo _arg0 = data.readTypedObject(ProxyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setCurrentProxyScriptUrl(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IPacProxyManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPacProxyManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(IPacProxyInstalledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPacProxyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(IPacProxyInstalledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPacProxyManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCurrentProxyScriptUrl(ProxyInfo proxyInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPacProxyManager.DESCRIPTOR);
                    _data.writeTypedObject(proxyInfo, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPacProxyManager {
        @Override
        public void addListener(IPacProxyInstalledListener listener) throws RemoteException {
        }

        @Override
        public void removeListener(IPacProxyInstalledListener listener) throws RemoteException {
        }

        @Override
        public void setCurrentProxyScriptUrl(ProxyInfo proxyInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

