/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkAddress;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkManagementEventObserver
extends IInterface {
    public void interfaceStatusChanged(String var1, boolean var2) throws RemoteException;

    public void interfaceLinkStateChanged(String var1, boolean var2) throws RemoteException;

    public void interfaceAdded(String var1) throws RemoteException;

    public void interfaceRemoved(String var1) throws RemoteException;

    public void addressUpdated(String var1, LinkAddress var2) throws RemoteException;

    public void addressRemoved(String var1, LinkAddress var2) throws RemoteException;

    public void limitReached(String var1, String var2) throws RemoteException;

    public void interfaceClassDataActivityChanged(int var1, boolean var2, long var3, int var5) throws RemoteException;

    public void interfaceDnsServerInfo(String var1, long var2, String[] var4) throws RemoteException;

    public void routeUpdated(RouteInfo var1) throws RemoteException;

    public void routeRemoved(RouteInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkManagementEventObserver {
        public static final String DESCRIPTOR = "android.net.INetworkManagementEventObserver";
        static final int TRANSACTION_interfaceStatusChanged = 1;
        static final int TRANSACTION_interfaceLinkStateChanged = 2;
        static final int TRANSACTION_interfaceAdded = 3;
        static final int TRANSACTION_interfaceRemoved = 4;
        static final int TRANSACTION_addressUpdated = 5;
        static final int TRANSACTION_addressRemoved = 6;
        static final int TRANSACTION_limitReached = 7;
        static final int TRANSACTION_interfaceClassDataActivityChanged = 8;
        static final int TRANSACTION_interfaceDnsServerInfo = 9;
        static final int TRANSACTION_routeUpdated = 10;
        static final int TRANSACTION_routeRemoved = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkManagementEventObserver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkManagementEventObserver) {
                return (INetworkManagementEventObserver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "interfaceStatusChanged";
                }
                case 2: {
                    return "interfaceLinkStateChanged";
                }
                case 3: {
                    return "interfaceAdded";
                }
                case 4: {
                    return "interfaceRemoved";
                }
                case 5: {
                    return "addressUpdated";
                }
                case 6: {
                    return "addressRemoved";
                }
                case 7: {
                    return "limitReached";
                }
                case 8: {
                    return "interfaceClassDataActivityChanged";
                }
                case 9: {
                    return "interfaceDnsServerInfo";
                }
                case 10: {
                    return "routeUpdated";
                }
                case 11: {
                    return "routeRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.interfaceStatusChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.interfaceLinkStateChanged(_arg0, _arg1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.interfaceAdded(_arg0);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.interfaceRemoved(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    LinkAddress _arg1 = data.readTypedObject(LinkAddress.CREATOR);
                    data.enforceNoDataAvail();
                    this.addressUpdated(_arg0, _arg1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    LinkAddress _arg1 = data.readTypedObject(LinkAddress.CREATOR);
                    data.enforceNoDataAvail();
                    this.addressRemoved(_arg0, _arg1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.limitReached(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    long _arg2 = data.readLong();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.interfaceClassDataActivityChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    String[] _arg2 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.interfaceDnsServerInfo(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    RouteInfo _arg0 = data.readTypedObject(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.routeUpdated(_arg0);
                    break;
                }
                case 11: {
                    RouteInfo _arg0 = data.readTypedObject(RouteInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.routeRemoved(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements INetworkManagementEventObserver {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceStatusChanged(String iface, boolean up) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeBoolean(up);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceLinkStateChanged(String iface, boolean up) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeBoolean(up);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceAdded(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceRemoved(String iface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addressUpdated(String iface, LinkAddress address) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(address, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addressRemoved(String iface, LinkAddress address) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeTypedObject(address, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void limitReached(String limitName, String iface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(limitName);
                    _data.writeString(iface);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceClassDataActivityChanged(int label, boolean active, long tsNanos, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(label);
                    _data.writeBoolean(active);
                    _data.writeLong(tsNanos);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interfaceDnsServerInfo(String iface, long lifetime, String[] servers) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iface);
                    _data.writeLong(lifetime);
                    _data.writeStringArray(servers);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void routeUpdated(RouteInfo route) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(route, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void routeRemoved(RouteInfo route) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(route, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkManagementEventObserver {
        @Override
        public void interfaceStatusChanged(String iface, boolean up) throws RemoteException {
        }

        @Override
        public void interfaceLinkStateChanged(String iface, boolean up) throws RemoteException {
        }

        @Override
        public void interfaceAdded(String iface) throws RemoteException {
        }

        @Override
        public void interfaceRemoved(String iface) throws RemoteException {
        }

        @Override
        public void addressUpdated(String iface, LinkAddress address) throws RemoteException {
        }

        @Override
        public void addressRemoved(String iface, LinkAddress address) throws RemoteException {
        }

        @Override
        public void limitReached(String limitName, String iface) throws RemoteException {
        }

        @Override
        public void interfaceClassDataActivityChanged(int label, boolean active, long tsNanos, int uid) throws RemoteException {
        }

        @Override
        public void interfaceDnsServerInfo(String iface, long lifetime, String[] servers) throws RemoteException {
        }

        @Override
        public void routeUpdated(RouteInfo route) throws RemoteException {
        }

        @Override
        public void routeRemoved(RouteInfo route) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

