/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ConnectivityDiagnosticsManager;
import android.net.Network;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IConnectivityDiagnosticsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.IConnectivityDiagnosticsCallback";

    public void onConnectivityReportAvailable(ConnectivityDiagnosticsManager.ConnectivityReport var1) throws RemoteException;

    public void onDataStallSuspected(ConnectivityDiagnosticsManager.DataStallReport var1) throws RemoteException;

    public void onNetworkConnectivityReported(Network var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectivityDiagnosticsCallback {
        static final int TRANSACTION_onConnectivityReportAvailable = 1;
        static final int TRANSACTION_onDataStallSuspected = 2;
        static final int TRANSACTION_onNetworkConnectivityReported = 3;

        public Stub() {
            this.attachInterface(this, IConnectivityDiagnosticsCallback.DESCRIPTOR);
        }

        public static IConnectivityDiagnosticsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IConnectivityDiagnosticsCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IConnectivityDiagnosticsCallback) {
                return (IConnectivityDiagnosticsCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConnectivityReportAvailable";
                }
                case 2: {
                    return "onDataStallSuspected";
                }
                case 3: {
                    return "onNetworkConnectivityReported";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IConnectivityDiagnosticsCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ConnectivityDiagnosticsManager.ConnectivityReport _arg0 = data.readTypedObject(ConnectivityDiagnosticsManager.ConnectivityReport.CREATOR);
                    this.onConnectivityReportAvailable(_arg0);
                    break;
                }
                case 2: {
                    ConnectivityDiagnosticsManager.DataStallReport _arg0 = data.readTypedObject(ConnectivityDiagnosticsManager.DataStallReport.CREATOR);
                    this.onDataStallSuspected(_arg0);
                    break;
                }
                case 3: {
                    Network _arg0 = data.readTypedObject(Network.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    this.onNetworkConnectivityReported(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IConnectivityDiagnosticsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IConnectivityDiagnosticsCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectivityReportAvailable(ConnectivityDiagnosticsManager.ConnectivityReport report) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IConnectivityDiagnosticsCallback.DESCRIPTOR);
                    _data.writeTypedObject(report, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataStallSuspected(ConnectivityDiagnosticsManager.DataStallReport report) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IConnectivityDiagnosticsCallback.DESCRIPTOR);
                    _data.writeTypedObject(report, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkConnectivityReported(Network n, boolean hasConnectivity) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IConnectivityDiagnosticsCallback.DESCRIPTOR);
                    _data.writeTypedObject(n, 0);
                    _data.writeBoolean(hasConnectivity);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IConnectivityDiagnosticsCallback {
        @Override
        public void onConnectivityReportAvailable(ConnectivityDiagnosticsManager.ConnectivityReport report) throws RemoteException {
        }

        @Override
        public void onDataStallSuspected(ConnectivityDiagnosticsManager.DataStallReport report) throws RemoteException {
        }

        @Override
        public void onNetworkConnectivityReported(Network n, boolean hasConnectivity) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

