/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.IpConfiguration;
import android.net.NetworkCapabilities;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class EthernetNetworkUpdateRequest
implements Parcelable {
    @Nullable
    private final IpConfiguration mIpConfig;
    @Nullable
    private final NetworkCapabilities mNetworkCapabilities;
    @NonNull
    public static final Parcelable.Creator<EthernetNetworkUpdateRequest> CREATOR = new Parcelable.Creator<EthernetNetworkUpdateRequest>(){

        public EthernetNetworkUpdateRequest[] newArray(int size) {
            return new EthernetNetworkUpdateRequest[size];
        }

        @Override
        public EthernetNetworkUpdateRequest createFromParcel(@NonNull Parcel source) {
            return new EthernetNetworkUpdateRequest(source);
        }
    };

    @Nullable
    public IpConfiguration getIpConfiguration() {
        return this.mIpConfig == null ? null : new IpConfiguration(this.mIpConfig);
    }

    @Nullable
    public NetworkCapabilities getNetworkCapabilities() {
        return this.mNetworkCapabilities == null ? null : new NetworkCapabilities(this.mNetworkCapabilities);
    }

    private EthernetNetworkUpdateRequest(@Nullable IpConfiguration ipConfig, @Nullable NetworkCapabilities networkCapabilities) {
        this.mIpConfig = ipConfig;
        this.mNetworkCapabilities = networkCapabilities;
    }

    private EthernetNetworkUpdateRequest(@NonNull Parcel source) {
        Objects.requireNonNull(source);
        this.mIpConfig = source.readParcelable(IpConfiguration.class.getClassLoader(), IpConfiguration.class);
        this.mNetworkCapabilities = source.readParcelable(NetworkCapabilities.class.getClassLoader(), NetworkCapabilities.class);
    }

    public String toString() {
        return "EthernetNetworkUpdateRequest{mIpConfig=" + this.mIpConfig + ", mNetworkCapabilities=" + this.mNetworkCapabilities + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthernetNetworkUpdateRequest that = (EthernetNetworkUpdateRequest)o;
        return Objects.equals(that.getIpConfiguration(), this.mIpConfig) && Objects.equals(that.getNetworkCapabilities(), this.mNetworkCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.mIpConfig, this.mNetworkCapabilities);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mIpConfig, flags);
        dest.writeParcelable(this.mNetworkCapabilities, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @Nullable
        private IpConfiguration mBuilderIpConfig;
        @Nullable
        private NetworkCapabilities mBuilderNetworkCapabilities;

        public Builder() {
        }

        public Builder(@NonNull EthernetNetworkUpdateRequest request) {
            Objects.requireNonNull(request);
            this.mBuilderIpConfig = null == request.mIpConfig ? null : new IpConfiguration(request.mIpConfig);
            this.mBuilderNetworkCapabilities = null == request.mNetworkCapabilities ? null : new NetworkCapabilities(request.mNetworkCapabilities);
        }

        @NonNull
        public Builder setIpConfiguration(@Nullable IpConfiguration ipConfig) {
            this.mBuilderIpConfig = ipConfig == null ? null : new IpConfiguration(ipConfig);
            return this;
        }

        @NonNull
        public Builder setNetworkCapabilities(@Nullable NetworkCapabilities nc) {
            this.mBuilderNetworkCapabilities = nc == null ? null : new NetworkCapabilities(nc);
            return this;
        }

        @NonNull
        public EthernetNetworkUpdateRequest build() {
            if (this.mBuilderIpConfig == null && this.mBuilderNetworkCapabilities == null) {
                throw new IllegalStateException("Cannot construct an empty EthernetNetworkUpdateRequest");
            }
            return new EthernetNetworkUpdateRequest(this.mBuilderIpConfig, this.mBuilderNetworkCapabilities);
        }
    }
}

