/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class CaptivePortalData
implements Parcelable {
    private final long mRefreshTimeMillis;
    @Nullable
    private final Uri mUserPortalUrl;
    @Nullable
    private final Uri mVenueInfoUrl;
    private final boolean mIsSessionExtendable;
    private final long mByteLimit;
    private final long mExpiryTimeMillis;
    private final boolean mCaptive;
    private final String mVenueFriendlyName;
    private final int mVenueInfoUrlSource;
    private final int mUserPortalUrlSource;
    public static final int CAPTIVE_PORTAL_DATA_SOURCE_OTHER = 0;
    public static final int CAPTIVE_PORTAL_DATA_SOURCE_PASSPOINT = 1;
    @NonNull
    public static final Parcelable.Creator<CaptivePortalData> CREATOR = new Parcelable.Creator<CaptivePortalData>(){

        @Override
        public CaptivePortalData createFromParcel(Parcel source) {
            return new CaptivePortalData(source);
        }

        public CaptivePortalData[] newArray(int size) {
            return new CaptivePortalData[size];
        }
    };

    private CaptivePortalData(long refreshTimeMillis, Uri userPortalUrl, Uri venueInfoUrl, boolean isSessionExtendable, long byteLimit, long expiryTimeMillis, boolean captive, CharSequence venueFriendlyName, int venueInfoUrlSource, int userPortalUrlSource) {
        this.mRefreshTimeMillis = refreshTimeMillis;
        this.mUserPortalUrl = userPortalUrl;
        this.mVenueInfoUrl = venueInfoUrl;
        this.mIsSessionExtendable = isSessionExtendable;
        this.mByteLimit = byteLimit;
        this.mExpiryTimeMillis = expiryTimeMillis;
        this.mCaptive = captive;
        this.mVenueFriendlyName = venueFriendlyName == null ? null : venueFriendlyName.toString();
        this.mVenueInfoUrlSource = venueInfoUrlSource;
        this.mUserPortalUrlSource = userPortalUrlSource;
    }

    private CaptivePortalData(Parcel p) {
        this(p.readLong(), (Uri)p.readParcelable(null), (Uri)p.readParcelable(null), p.readBoolean(), p.readLong(), p.readLong(), p.readBoolean(), p.readString(), p.readInt(), p.readInt());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mRefreshTimeMillis);
        dest.writeParcelable(this.mUserPortalUrl, 0);
        dest.writeParcelable(this.mVenueInfoUrl, 0);
        dest.writeBoolean(this.mIsSessionExtendable);
        dest.writeLong(this.mByteLimit);
        dest.writeLong(this.mExpiryTimeMillis);
        dest.writeBoolean(this.mCaptive);
        dest.writeString(this.mVenueFriendlyName);
        dest.writeInt(this.mVenueInfoUrlSource);
        dest.writeInt(this.mUserPortalUrlSource);
    }

    public long getRefreshTimeMillis() {
        return this.mRefreshTimeMillis;
    }

    @Nullable
    public Uri getUserPortalUrl() {
        return this.mUserPortalUrl;
    }

    @Nullable
    public Uri getVenueInfoUrl() {
        return this.mVenueInfoUrl;
    }

    public boolean isSessionExtendable() {
        return this.mIsSessionExtendable;
    }

    public long getByteLimit() {
        return this.mByteLimit;
    }

    public long getExpiryTimeMillis() {
        return this.mExpiryTimeMillis;
    }

    public boolean isCaptive() {
        return this.mCaptive;
    }

    public int getVenueInfoUrlSource() {
        return this.mVenueInfoUrlSource;
    }

    public int getUserPortalUrlSource() {
        return this.mUserPortalUrlSource;
    }

    @Nullable
    public CharSequence getVenueFriendlyName() {
        return this.mVenueFriendlyName;
    }

    public int hashCode() {
        return Objects.hash(this.mRefreshTimeMillis, this.mUserPortalUrl, this.mVenueInfoUrl, this.mIsSessionExtendable, this.mByteLimit, this.mExpiryTimeMillis, this.mCaptive, this.mVenueFriendlyName, this.mVenueInfoUrlSource, this.mUserPortalUrlSource);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CaptivePortalData)) {
            return false;
        }
        CaptivePortalData other = (CaptivePortalData)obj;
        return this.mRefreshTimeMillis == other.mRefreshTimeMillis && Objects.equals(this.mUserPortalUrl, other.mUserPortalUrl) && Objects.equals(this.mVenueInfoUrl, other.mVenueInfoUrl) && this.mIsSessionExtendable == other.mIsSessionExtendable && this.mByteLimit == other.mByteLimit && this.mExpiryTimeMillis == other.mExpiryTimeMillis && this.mCaptive == other.mCaptive && Objects.equals(this.mVenueFriendlyName, other.mVenueFriendlyName) && this.mVenueInfoUrlSource == other.mVenueInfoUrlSource && this.mUserPortalUrlSource == other.mUserPortalUrlSource;
    }

    public String toString() {
        return "CaptivePortalData {refreshTime: " + this.mRefreshTimeMillis + ", userPortalUrl: " + this.mUserPortalUrl + ", venueInfoUrl: " + this.mVenueInfoUrl + ", isSessionExtendable: " + this.mIsSessionExtendable + ", byteLimit: " + this.mByteLimit + ", expiryTime: " + this.mExpiryTimeMillis + ", captive: " + this.mCaptive + ", venueFriendlyName: " + this.mVenueFriendlyName + ", venueInfoUrlSource: " + this.mVenueInfoUrlSource + ", userPortalUrlSource: " + this.mUserPortalUrlSource + "}";
    }

    public static class Builder {
        private long mRefreshTime;
        private Uri mUserPortalUrl;
        private Uri mVenueInfoUrl;
        private boolean mIsSessionExtendable;
        private long mBytesRemaining = -1L;
        private long mExpiryTime = -1L;
        private boolean mCaptive;
        private CharSequence mVenueFriendlyName;
        private int mVenueInfoUrlSource = 0;
        private int mUserPortalUrlSource = 0;

        public Builder() {
        }

        public Builder(@Nullable CaptivePortalData data) {
            if (data == null) {
                return;
            }
            this.setRefreshTime(data.mRefreshTimeMillis).setUserPortalUrl(data.mUserPortalUrl, data.mUserPortalUrlSource).setVenueInfoUrl(data.mVenueInfoUrl, data.mVenueInfoUrlSource).setSessionExtendable(data.mIsSessionExtendable).setBytesRemaining(data.mByteLimit).setExpiryTime(data.mExpiryTimeMillis).setCaptive(data.mCaptive).setVenueFriendlyName(data.mVenueFriendlyName);
        }

        @NonNull
        public Builder setRefreshTime(long refreshTime) {
            this.mRefreshTime = refreshTime;
            return this;
        }

        @NonNull
        public Builder setUserPortalUrl(@Nullable Uri userPortalUrl) {
            return this.setUserPortalUrl(userPortalUrl, 0);
        }

        @NonNull
        public Builder setUserPortalUrl(@Nullable Uri userPortalUrl, int source) {
            this.mUserPortalUrl = userPortalUrl;
            this.mUserPortalUrlSource = source;
            return this;
        }

        @NonNull
        public Builder setVenueInfoUrl(@Nullable Uri venueInfoUrl) {
            return this.setVenueInfoUrl(venueInfoUrl, 0);
        }

        @NonNull
        public Builder setVenueInfoUrl(@Nullable Uri venueInfoUrl, int source) {
            this.mVenueInfoUrl = venueInfoUrl;
            this.mVenueInfoUrlSource = source;
            return this;
        }

        @NonNull
        public Builder setSessionExtendable(boolean sessionExtendable) {
            this.mIsSessionExtendable = sessionExtendable;
            return this;
        }

        @NonNull
        public Builder setBytesRemaining(long bytesRemaining) {
            this.mBytesRemaining = bytesRemaining;
            return this;
        }

        @NonNull
        public Builder setExpiryTime(long expiryTime) {
            this.mExpiryTime = expiryTime;
            return this;
        }

        @NonNull
        public Builder setCaptive(boolean captive) {
            this.mCaptive = captive;
            return this;
        }

        @NonNull
        public Builder setVenueFriendlyName(@Nullable CharSequence venueFriendlyName) {
            this.mVenueFriendlyName = venueFriendlyName;
            return this;
        }

        @NonNull
        public CaptivePortalData build() {
            return new CaptivePortalData(this.mRefreshTime, this.mUserPortalUrl, this.mVenueInfoUrl, this.mIsSessionExtendable, this.mBytesRemaining, this.mExpiryTime, this.mCaptive, this.mVenueFriendlyName, this.mVenueInfoUrlSource, this.mUserPortalUrlSource);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CaptivePortalDataSource {
    }
}

