/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.nearby.PresenceScanFilter;
import android.os.Parcel;

@SystemApi
public abstract class ScanFilter {
    private final int mType;
    private final int mMaxPathLoss;

    public static ScanFilter createFromParcel(Parcel in) {
        int type = in.readInt();
        switch (type) {
            case 2: {
                return PresenceScanFilter.createFromParcelBody(in);
            }
        }
        throw new IllegalStateException("Unexpected scan type (value " + type + ") in parcel.");
    }

    ScanFilter(int type, int maxPathLoss) {
        this.mType = type;
        this.mMaxPathLoss = maxPathLoss;
    }

    ScanFilter(int type, Parcel in) {
        this.mType = type;
        this.mMaxPathLoss = in.readInt();
    }

    public int getType() {
        return this.mType;
    }

    public int getMaxPathLoss() {
        return this.mMaxPathLoss;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mMaxPathLoss);
    }
}

