/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.nearby.DataElement;
import android.nearby.PublicCredential;
import android.nearby.ScanFilter;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class PresenceScanFilter
extends ScanFilter
implements Parcelable {
    private final List<PublicCredential> mCredentials;
    private final List<Integer> mPresenceActions;
    private final List<DataElement> mExtendedProperties;
    @NonNull
    public static final Parcelable.Creator<PresenceScanFilter> CREATOR = new Parcelable.Creator<PresenceScanFilter>(){

        @Override
        public PresenceScanFilter createFromParcel(Parcel in) {
            in.readInt();
            return PresenceScanFilter.createFromParcelBody(in);
        }

        public PresenceScanFilter[] newArray(int size) {
            return new PresenceScanFilter[size];
        }
    };

    @NonNull
    public List<PublicCredential> getCredentials() {
        return this.mCredentials;
    }

    @NonNull
    public List<Integer> getPresenceActions() {
        return this.mPresenceActions;
    }

    @NonNull
    public List<DataElement> getExtendedProperties() {
        return this.mExtendedProperties;
    }

    private PresenceScanFilter(int rssiThreshold, List<PublicCredential> credentials, List<Integer> presenceActions, List<DataElement> extendedProperties) {
        super(2, rssiThreshold);
        this.mCredentials = new ArrayList<PublicCredential>(credentials);
        this.mPresenceActions = new ArrayList<Integer>(presenceActions);
        this.mExtendedProperties = new ArrayList<DataElement>(extendedProperties);
    }

    private PresenceScanFilter(Parcel in) {
        super(2, in);
        this.mCredentials = new ArrayList<PublicCredential>();
        if (in.readInt() != 0) {
            in.readParcelableList(this.mCredentials, PublicCredential.class.getClassLoader(), PublicCredential.class);
        }
        this.mPresenceActions = new ArrayList<Integer>();
        if (in.readInt() != 0) {
            in.readList(this.mPresenceActions, Integer.class.getClassLoader(), Integer.class);
        }
        this.mExtendedProperties = new ArrayList<DataElement>();
        if (in.readInt() != 0) {
            in.readParcelableList(this.mExtendedProperties, DataElement.class.getClassLoader(), DataElement.class);
        }
    }

    static PresenceScanFilter createFromParcelBody(Parcel in) {
        return new PresenceScanFilter(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mCredentials.size());
        if (!this.mCredentials.isEmpty()) {
            dest.writeParcelableList(this.mCredentials, 0);
        }
        dest.writeInt(this.mPresenceActions.size());
        if (!this.mPresenceActions.isEmpty()) {
            dest.writeList(this.mPresenceActions);
        }
        dest.writeInt(this.mExtendedProperties.size());
        if (!this.mExtendedProperties.isEmpty()) {
            dest.writeParcelableList(this.mExtendedProperties, 0);
        }
    }

    public static class Builder {
        private int mMaxPathLoss = 127;
        private final Set<PublicCredential> mCredentials = new ArraySet<PublicCredential>();
        private final Set<Integer> mPresenceIdentities = new ArraySet<Integer>();
        private final Set<Integer> mPresenceActions = new ArraySet<Integer>();
        private final List<DataElement> mExtendedProperties = new ArrayList<DataElement>();

        @NonNull
        public Builder setMaxPathLoss(int maxPathLoss) {
            this.mMaxPathLoss = maxPathLoss;
            return this;
        }

        @NonNull
        public Builder addCredential(@NonNull PublicCredential credential) {
            Objects.requireNonNull(credential);
            this.mCredentials.add(credential);
            return this;
        }

        @NonNull
        public Builder addPresenceAction(int action) {
            this.mPresenceActions.add(action);
            return this;
        }

        @NonNull
        public Builder addExtendedProperty(@NonNull DataElement dataElement) {
            Objects.requireNonNull(dataElement);
            this.mExtendedProperties.add(dataElement);
            return this;
        }

        @NonNull
        public PresenceScanFilter build() {
            Preconditions.checkState(!this.mCredentials.isEmpty(), "credentials cannot be empty");
            return new PresenceScanFilter(this.mMaxPathLoss, new ArrayList<PublicCredential>(this.mCredentials), new ArrayList<Integer>(this.mPresenceActions), this.mExtendedProperties);
        }
    }
}

