/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.location.LocationManager;
import android.nearby.BroadcastCallback;
import android.nearby.BroadcastRequest;
import android.nearby.BroadcastRequestParcelable;
import android.nearby.FastPairDevice;
import android.nearby.IBroadcastListener;
import android.nearby.INearbyManager;
import android.nearby.IScanListener;
import android.nearby.NearbyDevice;
import android.nearby.NearbyDeviceParcelable;
import android.nearby.OffloadCapability;
import android.nearby.PoweredOffFindingEphemeralId;
import android.nearby.PresenceDevice;
import android.nearby.ScanCallback;
import android.nearby.ScanRequest;
import android.nearby.aidl.IOffloadCallback;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@SystemApi
public class NearbyManager {
    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    public static final int POWERED_OFF_FINDING_MODE_UNSUPPORTED = 0;
    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    public static final int POWERED_OFF_FINDING_MODE_DISABLED = 1;
    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    public static final int POWERED_OFF_FINDING_MODE_ENABLED = 2;
    private static final String TAG = "NearbyManager";
    private static final int POWERED_OFF_FINDING_EID_LENGTH = 20;
    private static final String POWER_OFF_FINDING_SUPPORTED_PROPERTY_RO = "ro.bluetooth.finder.supported";
    private static final String POWER_OFF_FINDING_SUPPORTED_PROPERTY_PERSIST = "persist.bluetooth.finder.supported";
    @GuardedBy(value={"sScanListeners"})
    private static final WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> sScanListeners = new WeakHashMap();
    @GuardedBy(value={"sBroadcastListeners"})
    private static final WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> sBroadcastListeners = new WeakHashMap();
    private final Context mContext;
    private final INearbyManager mService;

    NearbyManager(@NonNull Context context, @NonNull INearbyManager service) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(service);
        this.mContext = context;
        this.mService = service;
    }

    @Nullable
    private static NearbyDevice toClientNearbyDevice(NearbyDeviceParcelable nearbyDeviceParcelable, int scanType) {
        if (scanType == 1) {
            return new FastPairDevice.Builder().setName(nearbyDeviceParcelable.getName()).addMedium(nearbyDeviceParcelable.getMedium()).setRssi(nearbyDeviceParcelable.getRssi()).setTxPower(nearbyDeviceParcelable.getTxPower()).setModelId(nearbyDeviceParcelable.getFastPairModelId()).setBluetoothAddress(nearbyDeviceParcelable.getBluetoothAddress()).setData(nearbyDeviceParcelable.getData()).build();
        }
        if (scanType == 2) {
            PresenceDevice presenceDevice = nearbyDeviceParcelable.getPresenceDevice();
            if (presenceDevice == null) {
                Log.e(TAG, "Cannot find any Presence device in discovered NearbyDeviceParcelable");
            }
            return presenceDevice;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int startScan(@NonNull ScanRequest scanRequest, @NonNull Executor executor, @NonNull ScanCallback scanCallback) {
        Objects.requireNonNull(scanRequest, "scanRequest must not be null");
        Objects.requireNonNull(scanCallback, "scanCallback must not be null");
        Objects.requireNonNull(executor, "executor must not be null");
        try {
            WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> weakHashMap = sScanListeners;
            synchronized (weakHashMap) {
                ScanListenerTransport transport;
                WeakReference<ScanListenerTransport> reference = sScanListeners.get(scanCallback);
                ScanListenerTransport scanListenerTransport = transport = reference != null ? (ScanListenerTransport)reference.get() : null;
                if (transport == null) {
                    transport = new ScanListenerTransport(scanRequest.getScanType(), scanCallback, executor);
                } else {
                    Preconditions.checkState(transport.isRegistered());
                    transport.setExecutor(executor);
                }
                int status = this.mService.registerScanListener(scanRequest, transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                if (status != 1) {
                    return status;
                }
                sScanListeners.put(scanCallback, new WeakReference<ScanListenerTransport>(transport));
                return 1;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopScan(@NonNull ScanCallback scanCallback) {
        Preconditions.checkArgument(scanCallback != null, "invalid null scanCallback");
        try {
            WeakHashMap<ScanCallback, WeakReference<ScanListenerTransport>> weakHashMap = sScanListeners;
            synchronized (weakHashMap) {
                ScanListenerTransport transport;
                WeakReference<ScanListenerTransport> reference = sScanListeners.remove(scanCallback);
                ScanListenerTransport scanListenerTransport = transport = reference != null ? (ScanListenerTransport)reference.get() : null;
                if (transport != null) {
                    transport.unregister();
                    this.mService.unregisterScanListener(transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                } else {
                    Log.e(TAG, "Cannot stop scan with this callback because it is never registered.");
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void startBroadcast(@NonNull BroadcastRequest broadcastRequest, @NonNull Executor executor, @NonNull BroadcastCallback callback) {
        try {
            WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> weakHashMap = sBroadcastListeners;
            synchronized (weakHashMap) {
                BroadcastListenerTransport transport;
                WeakReference<BroadcastListenerTransport> reference = sBroadcastListeners.get(callback);
                BroadcastListenerTransport broadcastListenerTransport = transport = reference != null ? (BroadcastListenerTransport)reference.get() : null;
                if (transport == null) {
                    transport = new BroadcastListenerTransport(callback, executor);
                } else {
                    Preconditions.checkState(transport.isRegistered());
                    transport.setExecutor(executor);
                }
                this.mService.startBroadcast(new BroadcastRequestParcelable(broadcastRequest), transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                sBroadcastListeners.put(callback, new WeakReference<BroadcastListenerTransport>(transport));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ExecutorRegistration"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void stopBroadcast(@NonNull BroadcastCallback callback) {
        try {
            WeakHashMap<BroadcastCallback, WeakReference<BroadcastListenerTransport>> weakHashMap = sBroadcastListeners;
            synchronized (weakHashMap) {
                BroadcastListenerTransport transport;
                WeakReference<BroadcastListenerTransport> reference = sBroadcastListeners.remove(callback);
                BroadcastListenerTransport broadcastListenerTransport = transport = reference != null ? (BroadcastListenerTransport)reference.get() : null;
                if (transport != null) {
                    transport.unregister();
                    this.mService.stopBroadcast(transport, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                } else {
                    Log.e(TAG, "Cannot stop broadcast with this callback because it is never registered.");
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void queryOffloadCapability(@NonNull Executor executor, @NonNull Consumer<OffloadCapability> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.queryOffloadCapability(new OffloadTransport(executor, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void setPoweredOffFindingEphemeralIds(@NonNull List<byte[]> eids) {
        Objects.requireNonNull(eids);
        if (!this.isPoweredOffFindingSupported()) {
            throw new UnsupportedOperationException("Powered off finding is not supported on this device");
        }
        List<PoweredOffFindingEphemeralId> ephemeralIdList = eids.stream().map(eid -> {
            Preconditions.checkArgument(((byte[])eid).length == 20);
            PoweredOffFindingEphemeralId ephemeralId = new PoweredOffFindingEphemeralId();
            ephemeralId.bytes = eid;
            return ephemeralId;
        }).collect(Collectors.toUnmodifiableList());
        try {
            this.mService.setPoweredOffFindingEphemeralIds(ephemeralIdList);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void setPoweredOffFindingMode(int poweredOffFindingMode) {
        Preconditions.checkArgument(poweredOffFindingMode == 2 || poweredOffFindingMode == 1, "invalid poweredOffFindingMode");
        if (!this.isPoweredOffFindingSupported()) {
            throw new UnsupportedOperationException("Powered off finding is not supported on this device");
        }
        if (poweredOffFindingMode == 2) {
            Preconditions.checkState(this.areLocationAndBluetoothEnabled(), "Location services and Bluetooth must be on");
        }
        try {
            this.mService.setPoweredOffModeEnabled(poweredOffFindingMode == 2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.nearby.flags.powered_off_finding")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getPoweredOffFindingMode() {
        if (!this.isPoweredOffFindingSupported()) {
            return 0;
        }
        try {
            return this.mService.getPoweredOffModeEnabled() ? 2 : 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean isPoweredOffFindingSupported() {
        return Boolean.parseBoolean(SystemProperties.get(POWER_OFF_FINDING_SUPPORTED_PROPERTY_RO)) || Boolean.parseBoolean(SystemProperties.get(POWER_OFF_FINDING_SUPPORTED_PROPERTY_PERSIST));
    }

    private boolean areLocationAndBluetoothEnabled() {
        return this.mContext.getSystemService(BluetoothManager.class).getAdapter().isEnabled() && this.mContext.getSystemService(LocationManager.class).isLocationEnabled();
    }

    private static class ScanListenerTransport
    extends IScanListener.Stub {
        private int mScanType;
        @Nullable
        private volatile ScanCallback mScanCallback;
        private Executor mExecutor;

        ScanListenerTransport(int scanType, ScanCallback scanCallback, Executor executor) {
            Preconditions.checkArgument(scanCallback != null, "invalid null callback");
            Preconditions.checkState(ScanRequest.isValidScanType(scanType), "invalid scan type : " + scanType + ", scan type must be one of ScanRequest#SCAN_TYPE_");
            this.mScanType = scanType;
            this.mScanCallback = scanCallback;
            this.mExecutor = executor;
        }

        void setExecutor(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        boolean isRegistered() {
            return this.mScanCallback != null;
        }

        void unregister() {
            this.mScanCallback = null;
        }

        @Override
        public void onDiscovered(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                NearbyDevice nearbyDevice = NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType);
                if (this.mScanCallback != null && nearbyDevice != null) {
                    this.mScanCallback.onDiscovered(nearbyDevice);
                }
            });
        }

        @Override
        public void onUpdated(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                NearbyDevice nearbyDevice = NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType);
                if (this.mScanCallback != null && nearbyDevice != null) {
                    this.mScanCallback.onUpdated(NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType));
                }
            });
        }

        @Override
        public void onLost(NearbyDeviceParcelable nearbyDeviceParcelable) throws RemoteException {
            this.mExecutor.execute(() -> {
                NearbyDevice nearbyDevice = NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType);
                if (this.mScanCallback != null && nearbyDevice != null) {
                    this.mScanCallback.onLost(NearbyManager.toClientNearbyDevice(nearbyDeviceParcelable, this.mScanType));
                }
            });
        }

        @Override
        public void onError(int errorCode) {
            this.mExecutor.execute(() -> {
                if (this.mScanCallback != null) {
                    this.mScanCallback.onError(errorCode);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanStatus {
        public static final int UNKNOWN = 0;
        public static final int SUCCESS = 1;
        public static final int ERROR = 2;
    }

    private static class BroadcastListenerTransport
    extends IBroadcastListener.Stub {
        @Nullable
        private volatile BroadcastCallback mBroadcastCallback;
        private Executor mExecutor;

        BroadcastListenerTransport(BroadcastCallback broadcastCallback, Executor executor) {
            this.mBroadcastCallback = broadcastCallback;
            this.mExecutor = executor;
        }

        void setExecutor(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        boolean isRegistered() {
            return this.mBroadcastCallback != null;
        }

        void unregister() {
            this.mBroadcastCallback = null;
        }

        @Override
        public void onStatusChanged(int status) {
            this.mExecutor.execute(() -> {
                if (this.mBroadcastCallback != null) {
                    this.mBroadcastCallback.onStatusChanged(status);
                }
            });
        }
    }

    private static class OffloadTransport
    extends IOffloadCallback.Stub {
        private final Executor mExecutor;
        @Nullable
        volatile Consumer<OffloadCapability> mConsumer;

        OffloadTransport(Executor executor, Consumer<OffloadCapability> consumer) {
            Preconditions.checkArgument(executor != null, "illegal null executor");
            Preconditions.checkArgument(consumer != null, "illegal null consumer");
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        public void onQueryComplete(OffloadCapability capability) {
            this.mExecutor.execute(() -> {
                if (this.mConsumer != null) {
                    this.mConsumer.accept(capability);
                }
            });
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PoweredOffFindingMode {
    }
}

