/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.nearby.NearbyDevice;
import android.nearby.PresenceDevice;
import android.nearby.PublicCredential;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class NearbyDeviceParcelable
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<NearbyDeviceParcelable> CREATOR = new Parcelable.Creator<NearbyDeviceParcelable>(){

        @Override
        public NearbyDeviceParcelable createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setDeviceId(in.readLong());
            builder.setScanType(in.readInt());
            if (in.readInt() == 1) {
                builder.setName(in.readString());
            }
            builder.setMedium(in.readInt());
            builder.setTxPower(in.readInt());
            builder.setRssi(in.readInt());
            builder.setAction(in.readInt());
            builder.setPublicCredential(in.readParcelable(PublicCredential.class.getClassLoader(), PublicCredential.class));
            if (in.readInt() == 1) {
                builder.setFastPairModelId(in.readString());
            }
            if (in.readInt() == 1) {
                builder.setBluetoothAddress(in.readString());
            }
            if (in.readInt() == 1) {
                int dataLength = in.readInt();
                byte[] data = new byte[dataLength];
                in.readByteArray(data);
                builder.setData(data);
            }
            if (in.readInt() == 1) {
                int saltLength = in.readInt();
                byte[] salt = new byte[saltLength];
                in.readByteArray(salt);
                builder.setData(salt);
            }
            if (in.readInt() == 1) {
                builder.setPresenceDevice(in.readParcelable(PresenceDevice.class.getClassLoader(), PresenceDevice.class));
            }
            if (in.readInt() == 1) {
                int encryptionKeyTagLength = in.readInt();
                byte[] keyTag = new byte[encryptionKeyTagLength];
                in.readByteArray(keyTag);
                builder.setData(keyTag);
            }
            return builder.build();
        }

        public NearbyDeviceParcelable[] newArray(int size) {
            return new NearbyDeviceParcelable[size];
        }
    };
    private final long mDeviceId;
    int mScanType;
    @Nullable
    private final String mName;
    private final int mMedium;
    private final int mTxPower;
    private final int mRssi;
    private final int mAction;
    private final PublicCredential mPublicCredential;
    @Nullable
    private final String mBluetoothAddress;
    @Nullable
    private final String mFastPairModelId;
    @Nullable
    private final byte[] mData;
    @Nullable
    private final byte[] mSalt;
    @Nullable
    private final PresenceDevice mPresenceDevice;
    @Nullable
    private final byte[] mEncryptionKeyTag;

    private NearbyDeviceParcelable(long deviceId, int scanType, @Nullable String name, int medium, int TxPower, int rssi, int action, PublicCredential publicCredential, @Nullable String fastPairModelId, @Nullable String bluetoothAddress, @Nullable byte[] data, @Nullable byte[] salt, @Nullable PresenceDevice presenceDevice, @Nullable byte[] encryptionKeyTag) {
        this.mDeviceId = deviceId;
        this.mScanType = scanType;
        this.mName = name;
        this.mMedium = medium;
        this.mTxPower = TxPower;
        this.mRssi = rssi;
        this.mAction = action;
        this.mPublicCredential = publicCredential;
        this.mFastPairModelId = fastPairModelId;
        this.mBluetoothAddress = bluetoothAddress;
        this.mData = data;
        this.mSalt = salt;
        this.mPresenceDevice = presenceDevice;
        this.mEncryptionKeyTag = encryptionKeyTag;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mDeviceId);
        dest.writeInt(this.mScanType);
        dest.writeInt(this.mName == null ? 0 : 1);
        if (this.mName != null) {
            dest.writeString(this.mName);
        }
        dest.writeInt(this.mMedium);
        dest.writeInt(this.mTxPower);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mAction);
        dest.writeParcelable(this.mPublicCredential, flags);
        dest.writeInt(this.mFastPairModelId == null ? 0 : 1);
        if (this.mFastPairModelId != null) {
            dest.writeString(this.mFastPairModelId);
        }
        dest.writeInt(this.mBluetoothAddress == null ? 0 : 1);
        if (this.mBluetoothAddress != null) {
            dest.writeString(this.mBluetoothAddress);
        }
        dest.writeInt(this.mData == null ? 0 : 1);
        if (this.mData != null) {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
        dest.writeInt(this.mSalt == null ? 0 : 1);
        if (this.mSalt != null) {
            dest.writeInt(this.mSalt.length);
            dest.writeByteArray(this.mSalt);
        }
        dest.writeInt(this.mPresenceDevice == null ? 0 : 1);
        if (this.mPresenceDevice != null) {
            dest.writeParcelable(this.mPresenceDevice, 0);
        }
        dest.writeInt(this.mEncryptionKeyTag == null ? 0 : 1);
        if (this.mEncryptionKeyTag != null) {
            dest.writeInt(this.mEncryptionKeyTag.length);
            dest.writeByteArray(this.mEncryptionKeyTag);
        }
    }

    public String toString() {
        return "NearbyDeviceParcelable[deviceId=" + this.mDeviceId + ", scanType=" + this.mScanType + ", name=" + this.mName + ", medium=" + NearbyDevice.mediumToString(this.mMedium) + ", txPower=" + this.mTxPower + ", rssi=" + this.mRssi + ", action=" + this.mAction + ", bluetoothAddress=" + this.mBluetoothAddress + ", fastPairModelId=" + this.mFastPairModelId + ", data=" + Arrays.toString(this.mData) + ", salt=" + Arrays.toString(this.mSalt) + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof NearbyDeviceParcelable) {
            NearbyDeviceParcelable otherNearbyDeviceParcelable = (NearbyDeviceParcelable)other;
            return this.mDeviceId == otherNearbyDeviceParcelable.mDeviceId && this.mScanType == otherNearbyDeviceParcelable.mScanType && Objects.equals(this.mName, otherNearbyDeviceParcelable.mName) && this.mMedium == otherNearbyDeviceParcelable.mMedium && this.mTxPower == otherNearbyDeviceParcelable.mTxPower && this.mRssi == otherNearbyDeviceParcelable.mRssi && this.mAction == otherNearbyDeviceParcelable.mAction && Objects.equals(this.mPublicCredential, otherNearbyDeviceParcelable.mPublicCredential) && Objects.equals(this.mBluetoothAddress, otherNearbyDeviceParcelable.mBluetoothAddress) && Objects.equals(this.mFastPairModelId, otherNearbyDeviceParcelable.mFastPairModelId) && Arrays.equals(this.mData, otherNearbyDeviceParcelable.mData) && Arrays.equals(this.mSalt, otherNearbyDeviceParcelable.mSalt) && Objects.equals(this.mPresenceDevice, otherNearbyDeviceParcelable.mPresenceDevice) && Arrays.equals(this.mEncryptionKeyTag, otherNearbyDeviceParcelable.mEncryptionKeyTag);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mDeviceId, this.mScanType, this.mName, this.mMedium, this.mRssi, this.mAction, this.mPublicCredential.hashCode(), this.mBluetoothAddress, this.mFastPairModelId, Arrays.hashCode(this.mData), Arrays.hashCode(this.mSalt), this.mPresenceDevice, Arrays.hashCode(this.mEncryptionKeyTag));
    }

    public long getDeviceId() {
        return this.mDeviceId;
    }

    public int getScanType() {
        return this.mScanType;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public int getMedium() {
        return this.mMedium;
    }

    public int getTxPower() {
        return this.mTxPower;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getAction() {
        return this.mAction;
    }

    @NonNull
    public PublicCredential getPublicCredential() {
        return this.mPublicCredential;
    }

    @Nullable
    public String getFastPairModelId() {
        return this.mFastPairModelId;
    }

    @Nullable
    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    @Nullable
    public byte[] getData() {
        return this.mData;
    }

    @Nullable
    public byte[] getSalt() {
        return this.mSalt;
    }

    @Nullable
    public PresenceDevice getPresenceDevice() {
        return this.mPresenceDevice;
    }

    @Nullable
    public byte[] getEncryptionKeyTag() {
        return this.mEncryptionKeyTag;
    }

    public static class Builder {
        private long mDeviceId = -1L;
        @Nullable
        private String mName;
        private int mMedium;
        private int mTxPower;
        private int mRssi;
        private int mAction;
        private PublicCredential mPublicCredential;
        int mScanType;
        @Nullable
        private String mFastPairModelId;
        @Nullable
        private String mBluetoothAddress;
        @Nullable
        private byte[] mData;
        @Nullable
        private byte[] mSalt;
        @Nullable
        private PresenceDevice mPresenceDevice;
        @Nullable
        private byte[] mEncryptionKeyTag;

        public Builder setDeviceId(long deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        public Builder setScanType(int scanType) {
            this.mScanType = scanType;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setMedium(int medium) {
            this.mMedium = medium;
            return this;
        }

        @NonNull
        public Builder setTxPower(int txPower) {
            this.mTxPower = txPower;
            return this;
        }

        @NonNull
        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        @NonNull
        public Builder setAction(int action) {
            this.mAction = action;
            return this;
        }

        @NonNull
        public Builder setPublicCredential(@NonNull PublicCredential publicCredential) {
            this.mPublicCredential = publicCredential;
            return this;
        }

        @NonNull
        public Builder setFastPairModelId(@Nullable String fastPairModelId) {
            this.mFastPairModelId = fastPairModelId;
            return this;
        }

        @NonNull
        public Builder setBluetoothAddress(@Nullable String bluetoothAddress) {
            this.mBluetoothAddress = bluetoothAddress;
            return this;
        }

        @NonNull
        public Builder setData(@Nullable byte[] data) {
            this.mData = data;
            return this;
        }

        @NonNull
        public Builder setEncryptionKeyTag(@Nullable byte[] encryptionKeyTag) {
            this.mEncryptionKeyTag = encryptionKeyTag;
            return this;
        }

        @NonNull
        public Builder setSalt(@Nullable byte[] salt) {
            this.mSalt = salt;
            return this;
        }

        @Nullable
        public Builder setPresenceDevice(@Nullable PresenceDevice presenceDevice) {
            this.mPresenceDevice = presenceDevice;
            return this;
        }

        @NonNull
        public NearbyDeviceParcelable build() {
            return new NearbyDeviceParcelable(this.mDeviceId, this.mScanType, this.mName, this.mMedium, this.mTxPower, this.mRssi, this.mAction, this.mPublicCredential, this.mFastPairModelId, this.mBluetoothAddress, this.mData, this.mSalt, this.mPresenceDevice, this.mEncryptionKeyTag);
        }
    }
}

