/*
 * Decompiled with CFR 0.152.
 */
package android.nearby;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.net.connectivity.com.android.internal.util.Preconditions;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class CredentialElement
implements Parcelable {
    private final String mKey;
    private final byte[] mValue;
    @NonNull
    public static final Parcelable.Creator<CredentialElement> CREATOR = new Parcelable.Creator<CredentialElement>(){

        @Override
        public CredentialElement createFromParcel(Parcel in) {
            String key = in.readString();
            byte[] value = in.createByteArray();
            return new CredentialElement(key, value);
        }

        public CredentialElement[] newArray(int size) {
            return new CredentialElement[size];
        }
    };

    public CredentialElement(@NonNull String key, @NonNull byte[] value) {
        Preconditions.checkState(key != null && value != null, "neither key or value can be null");
        this.mKey = key;
        this.mValue = value;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mKey);
        dest.writeByteArray(this.mValue);
    }

    @NonNull
    public String getKey() {
        return this.mKey;
    }

    @NonNull
    public byte[] getValue() {
        return this.mValue;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof CredentialElement) {
            CredentialElement that = (CredentialElement)obj;
            return this.mKey.equals(that.mKey) && Arrays.equals(this.mValue, that.mValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mKey.hashCode(), Arrays.hashCode(this.mValue));
    }
}

