/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv.ad;

import android.graphics.Rect;
import android.media.tv.TvTrackInfo;
import android.media.tv.ad.ITvAdClient;
import android.media.tv.ad.ITvAdManagerCallback;
import android.media.tv.ad.TvAdServiceInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

public interface ITvAdManager
extends IInterface {
    public static final String DESCRIPTOR = "android.media.tv.ad.ITvAdManager";

    public List<TvAdServiceInfo> getTvAdServiceList(int var1) throws RemoteException;

    public void sendAppLinkCommand(String var1, Bundle var2, int var3) throws RemoteException;

    public void createSession(ITvAdClient var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public void releaseSession(IBinder var1, int var2) throws RemoteException;

    public void startAdService(IBinder var1, int var2) throws RemoteException;

    public void stopAdService(IBinder var1, int var2) throws RemoteException;

    public void resetAdService(IBinder var1, int var2) throws RemoteException;

    public void setSurface(IBinder var1, Surface var2, int var3) throws RemoteException;

    public void dispatchSurfaceChanged(IBinder var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void sendCurrentVideoBounds(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void sendCurrentChannelUri(IBinder var1, Uri var2, int var3) throws RemoteException;

    public void sendTrackInfoList(IBinder var1, List<TvTrackInfo> var2, int var3) throws RemoteException;

    public void sendCurrentTvInputId(IBinder var1, String var2, int var3) throws RemoteException;

    public void sendSigningResult(IBinder var1, String var2, byte[] var3, int var4) throws RemoteException;

    public void notifyError(IBinder var1, String var2, Bundle var3, int var4) throws RemoteException;

    public void notifyTvMessage(IBinder var1, int var2, Bundle var3, int var4) throws RemoteException;

    public void registerCallback(ITvAdManagerCallback var1, int var2) throws RemoteException;

    public void unregisterCallback(ITvAdManagerCallback var1, int var2) throws RemoteException;

    public void createMediaView(IBinder var1, IBinder var2, Rect var3, int var4) throws RemoteException;

    public void relayoutMediaView(IBinder var1, Rect var2, int var3) throws RemoteException;

    public void removeMediaView(IBinder var1, int var2) throws RemoteException;

    public void notifyTvInputSessionData(IBinder var1, String var2, Bundle var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvAdManager {
        static final int TRANSACTION_getTvAdServiceList = 1;
        static final int TRANSACTION_sendAppLinkCommand = 2;
        static final int TRANSACTION_createSession = 3;
        static final int TRANSACTION_releaseSession = 4;
        static final int TRANSACTION_startAdService = 5;
        static final int TRANSACTION_stopAdService = 6;
        static final int TRANSACTION_resetAdService = 7;
        static final int TRANSACTION_setSurface = 8;
        static final int TRANSACTION_dispatchSurfaceChanged = 9;
        static final int TRANSACTION_sendCurrentVideoBounds = 10;
        static final int TRANSACTION_sendCurrentChannelUri = 11;
        static final int TRANSACTION_sendTrackInfoList = 12;
        static final int TRANSACTION_sendCurrentTvInputId = 13;
        static final int TRANSACTION_sendSigningResult = 14;
        static final int TRANSACTION_notifyError = 15;
        static final int TRANSACTION_notifyTvMessage = 16;
        static final int TRANSACTION_registerCallback = 17;
        static final int TRANSACTION_unregisterCallback = 18;
        static final int TRANSACTION_createMediaView = 19;
        static final int TRANSACTION_relayoutMediaView = 20;
        static final int TRANSACTION_removeMediaView = 21;
        static final int TRANSACTION_notifyTvInputSessionData = 22;

        public Stub() {
            this.attachInterface(this, ITvAdManager.DESCRIPTOR);
        }

        public static ITvAdManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITvAdManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITvAdManager) {
                return (ITvAdManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTvAdServiceList";
                }
                case 2: {
                    return "sendAppLinkCommand";
                }
                case 3: {
                    return "createSession";
                }
                case 4: {
                    return "releaseSession";
                }
                case 5: {
                    return "startAdService";
                }
                case 6: {
                    return "stopAdService";
                }
                case 7: {
                    return "resetAdService";
                }
                case 8: {
                    return "setSurface";
                }
                case 9: {
                    return "dispatchSurfaceChanged";
                }
                case 10: {
                    return "sendCurrentVideoBounds";
                }
                case 11: {
                    return "sendCurrentChannelUri";
                }
                case 12: {
                    return "sendTrackInfoList";
                }
                case 13: {
                    return "sendCurrentTvInputId";
                }
                case 14: {
                    return "sendSigningResult";
                }
                case 15: {
                    return "notifyError";
                }
                case 16: {
                    return "notifyTvMessage";
                }
                case 17: {
                    return "registerCallback";
                }
                case 18: {
                    return "unregisterCallback";
                }
                case 19: {
                    return "createMediaView";
                }
                case 20: {
                    return "relayoutMediaView";
                }
                case 21: {
                    return "removeMediaView";
                }
                case 22: {
                    return "notifyTvInputSessionData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITvAdManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<TvAdServiceInfo> _result = this.getTvAdServiceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAppLinkCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ITvAdClient _arg0 = ITvAdClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createSession(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.releaseSession(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startAdService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopAdService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetAdService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSurface(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.dispatchSurfaceChanged(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentVideoBounds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentChannelUri(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    ArrayList<TvTrackInfo> _arg1 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendTrackInfoList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendCurrentTvInputId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    byte[] _arg2 = data.createByteArray();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendSigningResult(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyError(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTvMessage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    ITvAdManagerCallback _arg0 = ITvAdManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    ITvAdManagerCallback _arg0 = ITvAdManagerCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.createMediaView(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.relayoutMediaView(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeMediaView(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyTvInputSessionData(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 21;
        }

        private static class Proxy
        implements ITvAdManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITvAdManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<TvAdServiceInfo> getTvAdServiceList(int userId) throws RemoteException {
                ArrayList<TvAdServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(TvAdServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAppLinkCommand(String serviceId, Bundle command, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeString(serviceId);
                    _data.writeTypedObject(command, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(ITvAdClient client, String serviceId, String type, int seq, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(serviceId);
                    _data.writeString(type);
                    _data.writeInt(seq);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAdService(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAdService(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetAdService(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(format);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentVideoBounds(IBinder sessionToken, Rect bounds, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(bounds, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedList(tracks, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(inputId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(signingId);
                    _data.writeByteArray(result);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(errMsg);
                    _data.writeTypedObject(params, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTvMessage(IBinder sessionToken, int type, Bundle data, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(ITvAdManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCallback(ITvAdManagerCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeStrongBinder(windowToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeTypedObject(frame, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyTvInputSessionData(IBinder sessionToken, String type, Bundle data, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITvAdManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionToken);
                    _data.writeString(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvAdManager {
        @Override
        public List<TvAdServiceInfo> getTvAdServiceList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void sendAppLinkCommand(String serviceId, Bundle command, int userId) throws RemoteException {
        }

        @Override
        public void createSession(ITvAdClient client, String serviceId, String type, int seq, int userId) throws RemoteException {
        }

        @Override
        public void releaseSession(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void startAdService(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void stopAdService(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void resetAdService(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void setSurface(IBinder sessionToken, Surface surface, int userId) throws RemoteException {
        }

        @Override
        public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentVideoBounds(IBinder sessionToken, Rect bounds, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentChannelUri(IBinder sessionToken, Uri channelUri, int userId) throws RemoteException {
        }

        @Override
        public void sendTrackInfoList(IBinder sessionToken, List<TvTrackInfo> tracks, int userId) throws RemoteException {
        }

        @Override
        public void sendCurrentTvInputId(IBinder sessionToken, String inputId, int userId) throws RemoteException {
        }

        @Override
        public void sendSigningResult(IBinder sessionToken, String signingId, byte[] result, int userId) throws RemoteException {
        }

        @Override
        public void notifyError(IBinder sessionToken, String errMsg, Bundle params, int userId) throws RemoteException {
        }

        @Override
        public void notifyTvMessage(IBinder sessionToken, int type, Bundle data, int userId) throws RemoteException {
        }

        @Override
        public void registerCallback(ITvAdManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ITvAdManagerCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void createMediaView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void relayoutMediaView(IBinder sessionToken, Rect frame, int userId) throws RemoteException {
        }

        @Override
        public void removeMediaView(IBinder sessionToken, int userId) throws RemoteException {
        }

        @Override
        public void notifyTvInputSessionData(IBinder sessionToken, String type, Bundle data, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

