/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.media.tv.BroadcastInfoRequest;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

public class StreamEventRequest
extends BroadcastInfoRequest
implements Parcelable {
    private static final int REQUEST_TYPE = 5;
    @NonNull
    public static final Parcelable.Creator<StreamEventRequest> CREATOR = new Parcelable.Creator<StreamEventRequest>(){

        @Override
        public StreamEventRequest createFromParcel(Parcel source) {
            source.readInt();
            return StreamEventRequest.createFromParcelBody(source);
        }

        public StreamEventRequest[] newArray(int size) {
            return new StreamEventRequest[size];
        }
    };
    private final Uri mTargetUri;
    private final String mEventName;

    static StreamEventRequest createFromParcelBody(Parcel in) {
        return new StreamEventRequest(in);
    }

    public StreamEventRequest(int requestId, int option, @NonNull Uri targetUri, @NonNull String eventName) {
        super(5, requestId, option);
        this.mTargetUri = targetUri;
        this.mEventName = eventName;
    }

    StreamEventRequest(Parcel source) {
        super(5, source);
        String uriString = source.readString();
        this.mTargetUri = uriString == null ? null : Uri.parse(uriString);
        this.mEventName = source.readString();
    }

    @NonNull
    public Uri getTargetUri() {
        return this.mTargetUri;
    }

    @NonNull
    public String getEventName() {
        return this.mEventName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        String uriString = this.mTargetUri == null ? null : this.mTargetUri.toString();
        dest.writeString(uriString);
        dest.writeString(this.mEventName);
    }
}

