/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.media.AudioPresentation;
import android.media.tv.AdBuffer;
import android.media.tv.AdResponse;
import android.media.tv.AitInfo;
import android.media.tv.BroadcastInfoResponse;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InputChannel;
import java.util.ArrayList;
import java.util.List;

public interface ITvInputClient
extends IInterface {
    public void onSessionCreated(String var1, IBinder var2, InputChannel var3, int var4) throws RemoteException;

    public void onSessionReleased(int var1) throws RemoteException;

    public void onSessionEvent(String var1, Bundle var2, int var3) throws RemoteException;

    public void onChannelRetuned(Uri var1, int var2) throws RemoteException;

    public void onAudioPresentationsChanged(List<AudioPresentation> var1, int var2) throws RemoteException;

    public void onAudioPresentationSelected(int var1, int var2, int var3) throws RemoteException;

    public void onTracksChanged(List<TvTrackInfo> var1, int var2) throws RemoteException;

    public void onTrackSelected(int var1, String var2, int var3) throws RemoteException;

    public void onVideoAvailable(int var1) throws RemoteException;

    public void onVideoUnavailable(int var1, int var2) throws RemoteException;

    public void onVideoFreezeUpdated(boolean var1, int var2) throws RemoteException;

    public void onContentAllowed(int var1) throws RemoteException;

    public void onContentBlocked(String var1, int var2) throws RemoteException;

    public void onLayoutSurface(int var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public void onTimeShiftStatusChanged(int var1, int var2) throws RemoteException;

    public void onTimeShiftStartPositionChanged(long var1, int var3) throws RemoteException;

    public void onTimeShiftCurrentPositionChanged(long var1, int var3) throws RemoteException;

    public void onAitInfoUpdated(AitInfo var1, int var2) throws RemoteException;

    public void onSignalStrength(int var1, int var2) throws RemoteException;

    public void onCueingMessageAvailability(boolean var1, int var2) throws RemoteException;

    public void onTimeShiftMode(int var1, int var2) throws RemoteException;

    public void onAvailableSpeeds(float[] var1, int var2) throws RemoteException;

    public void onTvMessage(int var1, Bundle var2, int var3) throws RemoteException;

    public void onTuned(Uri var1, int var2) throws RemoteException;

    public void onRecordingStopped(Uri var1, int var2) throws RemoteException;

    public void onError(int var1, int var2) throws RemoteException;

    public void onBroadcastInfoResponse(BroadcastInfoResponse var1, int var2) throws RemoteException;

    public void onAdResponse(AdResponse var1, int var2) throws RemoteException;

    public void onAdBufferConsumed(AdBuffer var1, int var2) throws RemoteException;

    public void onTvInputSessionData(String var1, Bundle var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputClient {
        public static final String DESCRIPTOR = "android.media.tv.ITvInputClient";
        static final int TRANSACTION_onSessionCreated = 1;
        static final int TRANSACTION_onSessionReleased = 2;
        static final int TRANSACTION_onSessionEvent = 3;
        static final int TRANSACTION_onChannelRetuned = 4;
        static final int TRANSACTION_onAudioPresentationsChanged = 5;
        static final int TRANSACTION_onAudioPresentationSelected = 6;
        static final int TRANSACTION_onTracksChanged = 7;
        static final int TRANSACTION_onTrackSelected = 8;
        static final int TRANSACTION_onVideoAvailable = 9;
        static final int TRANSACTION_onVideoUnavailable = 10;
        static final int TRANSACTION_onVideoFreezeUpdated = 11;
        static final int TRANSACTION_onContentAllowed = 12;
        static final int TRANSACTION_onContentBlocked = 13;
        static final int TRANSACTION_onLayoutSurface = 14;
        static final int TRANSACTION_onTimeShiftStatusChanged = 15;
        static final int TRANSACTION_onTimeShiftStartPositionChanged = 16;
        static final int TRANSACTION_onTimeShiftCurrentPositionChanged = 17;
        static final int TRANSACTION_onAitInfoUpdated = 18;
        static final int TRANSACTION_onSignalStrength = 19;
        static final int TRANSACTION_onCueingMessageAvailability = 20;
        static final int TRANSACTION_onTimeShiftMode = 21;
        static final int TRANSACTION_onAvailableSpeeds = 22;
        static final int TRANSACTION_onTvMessage = 23;
        static final int TRANSACTION_onTuned = 24;
        static final int TRANSACTION_onRecordingStopped = 25;
        static final int TRANSACTION_onError = 26;
        static final int TRANSACTION_onBroadcastInfoResponse = 27;
        static final int TRANSACTION_onAdResponse = 28;
        static final int TRANSACTION_onAdBufferConsumed = 29;
        static final int TRANSACTION_onTvInputSessionData = 30;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputClient) {
                return (ITvInputClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionCreated";
                }
                case 2: {
                    return "onSessionReleased";
                }
                case 3: {
                    return "onSessionEvent";
                }
                case 4: {
                    return "onChannelRetuned";
                }
                case 5: {
                    return "onAudioPresentationsChanged";
                }
                case 6: {
                    return "onAudioPresentationSelected";
                }
                case 7: {
                    return "onTracksChanged";
                }
                case 8: {
                    return "onTrackSelected";
                }
                case 9: {
                    return "onVideoAvailable";
                }
                case 10: {
                    return "onVideoUnavailable";
                }
                case 11: {
                    return "onVideoFreezeUpdated";
                }
                case 12: {
                    return "onContentAllowed";
                }
                case 13: {
                    return "onContentBlocked";
                }
                case 14: {
                    return "onLayoutSurface";
                }
                case 15: {
                    return "onTimeShiftStatusChanged";
                }
                case 16: {
                    return "onTimeShiftStartPositionChanged";
                }
                case 17: {
                    return "onTimeShiftCurrentPositionChanged";
                }
                case 18: {
                    return "onAitInfoUpdated";
                }
                case 19: {
                    return "onSignalStrength";
                }
                case 20: {
                    return "onCueingMessageAvailability";
                }
                case 21: {
                    return "onTimeShiftMode";
                }
                case 22: {
                    return "onAvailableSpeeds";
                }
                case 23: {
                    return "onTvMessage";
                }
                case 24: {
                    return "onTuned";
                }
                case 25: {
                    return "onRecordingStopped";
                }
                case 26: {
                    return "onError";
                }
                case 27: {
                    return "onBroadcastInfoResponse";
                }
                case 28: {
                    return "onAdResponse";
                }
                case 29: {
                    return "onAdBufferConsumed";
                }
                case 30: {
                    return "onTvInputSessionData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    InputChannel _arg2 = data.readTypedObject(InputChannel.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionReleased(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSessionEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onChannelRetuned(_arg0, _arg1);
                    break;
                }
                case 5: {
                    ArrayList<AudioPresentation> _arg0 = data.createTypedArrayList(AudioPresentation.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAudioPresentationsChanged(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAudioPresentationSelected(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    ArrayList<TvTrackInfo> _arg0 = data.createTypedArrayList(TvTrackInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTracksChanged(_arg0, _arg1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTrackSelected(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVideoAvailable(_arg0);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVideoUnavailable(_arg0, _arg1);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVideoFreezeUpdated(_arg0, _arg1);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onContentAllowed(_arg0);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onContentBlocked(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutSurface(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftStatusChanged(_arg0, _arg1);
                    break;
                }
                case 16: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftStartPositionChanged(_arg0, _arg1);
                    break;
                }
                case 17: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftCurrentPositionChanged(_arg0, _arg1);
                    break;
                }
                case 18: {
                    AitInfo _arg0 = data.readTypedObject(AitInfo.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAitInfoUpdated(_arg0, _arg1);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSignalStrength(_arg0, _arg1);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCueingMessageAvailability(_arg0, _arg1);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTimeShiftMode(_arg0, _arg1);
                    break;
                }
                case 22: {
                    float[] _arg0 = data.createFloatArray();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAvailableSpeeds(_arg0, _arg1);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTvMessage(_arg0, _arg1, _arg2);
                    break;
                }
                case 24: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTuned(_arg0, _arg1);
                    break;
                }
                case 25: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRecordingStopped(_arg0, _arg1);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                case 27: {
                    BroadcastInfoResponse _arg0 = data.readTypedObject(BroadcastInfoResponse.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBroadcastInfoResponse(_arg0, _arg1);
                    break;
                }
                case 28: {
                    AdResponse _arg0 = data.readTypedObject(AdResponse.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdResponse(_arg0, _arg1);
                    break;
                }
                case 29: {
                    AdBuffer _arg0 = data.readTypedObject(AdBuffer.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onAdBufferConsumed(_arg0, _arg1);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTvInputSessionData(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 29;
        }

        private static class Proxy
        implements ITvInputClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(inputId);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(channel, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionReleased(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEvent(String name, Bundle args, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeTypedObject(args, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChannelRetuned(Uri channelUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioPresentationsChanged(List<AudioPresentation> AudioPresentations, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(AudioPresentations, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioPresentationSelected(int presentationId, int programId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(presentationId);
                    _data.writeInt(programId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTracksChanged(List<TvTrackInfo> tracks, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(tracks, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTrackSelected(int type, String trackId, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoAvailable(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoUnavailable(int reason, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoFreezeUpdated(boolean isFrozen, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isFrozen);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContentAllowed(int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContentBlocked(String rating, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(rating);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(left);
                    _data.writeInt(top);
                    _data.writeInt(right);
                    _data.writeInt(bottom);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftStatusChanged(int status, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftStartPositionChanged(long timeMs, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftCurrentPositionChanged(long timeMs, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAitInfoUpdated(AitInfo aitInfo, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(aitInfo, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrength(int stength, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(stength);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCueingMessageAvailability(boolean available, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(available);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeShiftMode(int mode, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mode);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAvailableSpeeds(float[] speeds, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(speeds);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvMessage(int type, Bundle data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTuned(Uri channelUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(channelUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecordingStopped(Uri recordedProgramUri, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(recordedProgramUri, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(error);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBroadcastInfoResponse(BroadcastInfoResponse response, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdResponse(AdResponse response, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdBufferConsumed(AdBuffer buffer, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(buffer, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTvInputSessionData(String type, Bundle data, int seq) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(type);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(seq);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInputClient {
        @Override
        public void onSessionCreated(String inputId, IBinder token, InputChannel channel, int seq) throws RemoteException {
        }

        @Override
        public void onSessionReleased(int seq) throws RemoteException {
        }

        @Override
        public void onSessionEvent(String name, Bundle args, int seq) throws RemoteException {
        }

        @Override
        public void onChannelRetuned(Uri channelUri, int seq) throws RemoteException {
        }

        @Override
        public void onAudioPresentationsChanged(List<AudioPresentation> AudioPresentations, int seq) throws RemoteException {
        }

        @Override
        public void onAudioPresentationSelected(int presentationId, int programId, int seq) throws RemoteException {
        }

        @Override
        public void onTracksChanged(List<TvTrackInfo> tracks, int seq) throws RemoteException {
        }

        @Override
        public void onTrackSelected(int type, String trackId, int seq) throws RemoteException {
        }

        @Override
        public void onVideoAvailable(int seq) throws RemoteException {
        }

        @Override
        public void onVideoUnavailable(int reason, int seq) throws RemoteException {
        }

        @Override
        public void onVideoFreezeUpdated(boolean isFrozen, int seq) throws RemoteException {
        }

        @Override
        public void onContentAllowed(int seq) throws RemoteException {
        }

        @Override
        public void onContentBlocked(String rating, int seq) throws RemoteException {
        }

        @Override
        public void onLayoutSurface(int left, int top, int right, int bottom, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftStatusChanged(int status, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftStartPositionChanged(long timeMs, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftCurrentPositionChanged(long timeMs, int seq) throws RemoteException {
        }

        @Override
        public void onAitInfoUpdated(AitInfo aitInfo, int seq) throws RemoteException {
        }

        @Override
        public void onSignalStrength(int stength, int seq) throws RemoteException {
        }

        @Override
        public void onCueingMessageAvailability(boolean available, int seq) throws RemoteException {
        }

        @Override
        public void onTimeShiftMode(int mode, int seq) throws RemoteException {
        }

        @Override
        public void onAvailableSpeeds(float[] speeds, int seq) throws RemoteException {
        }

        @Override
        public void onTvMessage(int type, Bundle data, int seq) throws RemoteException {
        }

        @Override
        public void onTuned(Uri channelUri, int seq) throws RemoteException {
        }

        @Override
        public void onRecordingStopped(Uri recordedProgramUri, int seq) throws RemoteException {
        }

        @Override
        public void onError(int error, int seq) throws RemoteException {
        }

        @Override
        public void onBroadcastInfoResponse(BroadcastInfoResponse response, int seq) throws RemoteException {
        }

        @Override
        public void onAdResponse(AdResponse response, int seq) throws RemoteException {
        }

        @Override
        public void onAdBufferConsumed(AdBuffer buffer, int seq) throws RemoteException {
        }

        @Override
        public void onTvInputSessionData(String type, Bundle data, int seq) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

